/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Iterator;

public class LDIFWriter
implements LDAPWriter {
    private Boolean requestFile = null;
    private BufferedWriter bufWriter;
    private String version;

    public LDIFWriter(OutputStream outputStream) throws IOException {
        this(outputStream, "1", null);
    }

    public LDIFWriter(OutputStream outputStream, String string, boolean bl) throws IOException {
        this(outputStream, string, new Boolean(bl));
    }

    private LDIFWriter(OutputStream outputStream, String string, Boolean bl) throws IOException {
        if (string != "1") {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFWriter: LDIF version:found: " + string + ", Should be: 1");
        }
        this.version = string;
        this.requestFile = bl;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        this.bufWriter = new BufferedWriter(outputStreamWriter);
        this.writeComments("This LDIF file was generated by the LDIF APIs. of Novell's Java LDAP SDK");
        this.writeVersionLine();
    }

    public void writeEntry(LDAPEntry lDAPEntry) throws IOException {
        this.writeEntry(lDAPEntry, new LDAPControl[0]);
    }

    public void writeEntry(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) throws IOException {
        this.requestFile = Boolean.FALSE;
        this.writeAddRequest(lDAPEntry, lDAPControlArray);
        this.bufWriter.newLine();
    }

    public void writeMessage(LDAPMessage lDAPMessage) throws IOException {
        LDAPControl[] lDAPControlArray = lDAPMessage.getControls();
        switch (lDAPMessage.getType()) {
            case 4: {
                if (this.requestFile == null) {
                    this.requestFile = Boolean.FALSE;
                }
                if (!this.isRequest()) break;
                throw new RuntimeException("Attempting to write content  in a request stream");
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                if (this.requestFile == null) {
                    this.requestFile = Boolean.TRUE;
                }
                if (this.isRequest()) break;
                throw new RuntimeException("Attempting to write request  in a content stream");
            }
            default: {
                throw new RuntimeException("Unsupported request type: " + lDAPMessage.toString());
            }
        }
        switch (lDAPMessage.getType()) {
            case 4: {
                LDAPSearchResult lDAPSearchResult = (LDAPSearchResult)lDAPMessage;
                this.writeAddRequest(lDAPSearchResult.getEntry(), lDAPControlArray);
                break;
            }
            case 8: {
                LDAPAddRequest lDAPAddRequest = (LDAPAddRequest)lDAPMessage;
                this.writeAddRequest(lDAPAddRequest.getEntry(), lDAPControlArray);
                break;
            }
            case 10: {
                LDAPDeleteRequest lDAPDeleteRequest = (LDAPDeleteRequest)lDAPMessage;
                this.writeDeleteRequest(lDAPDeleteRequest.getDN(), lDAPControlArray);
                break;
            }
            case 12: {
                LDAPModifyDNRequest lDAPModifyDNRequest = (LDAPModifyDNRequest)lDAPMessage;
                this.writeModifyDNRequest(lDAPModifyDNRequest.getDN(), lDAPModifyDNRequest.getNewRDN(), lDAPModifyDNRequest.getDeleteOldRDN(), lDAPModifyDNRequest.getParentDN(), lDAPControlArray);
                break;
            }
            case 6: {
                LDAPModifyRequest lDAPModifyRequest = (LDAPModifyRequest)lDAPMessage;
                this.writeModifyRequest(lDAPModifyRequest.getDN(), lDAPModifyRequest.getModifications(), lDAPControlArray);
            }
        }
        this.bufWriter.newLine();
    }

    public void writeComments(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            this.bufWriter.write("# ", 0, 2);
            this.bufWriter.write(string2, 0, string2.length());
            this.bufWriter.newLine();
        }
    }

    public void writeError(Exception exception) throws IOException {
        this.writeComments(exception.toString());
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return this.requestFile;
    }

    public boolean isPrintable(byte[] byArray) {
        if (byArray == null) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFWriter: null pointer");
        }
        if (byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                if ((byArray[i] & 0xFF) >= 32 && (byArray[i] & 0xFF) <= 126) continue;
                return false;
            }
        }
        return true;
    }

    private void writeVersionLine() throws IOException {
        String string = new String("version: " + this.getVersion());
        this.bufWriter.write(string, 0, string.length());
        this.bufWriter.newLine();
        this.bufWriter.newLine();
    }

    private void writeLine(String string) throws IOException {
        int n = string.length();
        if (string != null && n != 0) {
            if (n <= 76) {
                this.bufWriter.write(string, 0, n);
            } else {
                int n2 = 0;
                this.bufWriter.write(string, n2, 76);
                n2 += 76;
                this.bufWriter.newLine();
                while (n - n2 > 75) {
                    this.bufWriter.write(" ", 0, 1);
                    this.bufWriter.write(string, n2, 75);
                    n2 += 75;
                    this.bufWriter.newLine();
                }
                this.bufWriter.write(" ", 0, 1);
                this.bufWriter.write(string, n2, n - n2);
            }
            this.bufWriter.newLine();
        }
    }

    private void writeAddRequest(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) throws IOException {
        this.writeDN(lDAPEntry.getDN());
        if (this.isRequest()) {
            if (lDAPControlArray != null) {
                this.writeControls(lDAPControlArray);
            }
            this.writeLine("changetype: add");
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Iterator iterator = lDAPAttributeSet.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            String string = lDAPAttribute.getName();
            byte[][] byArray = lDAPAttribute.getByteValueArray();
            if (byArray == null) continue;
            for (int i = 0; i < byArray.length; ++i) {
                this.writeAttribute(string, byArray[i]);
            }
        }
    }

    private void writeModifyRequest(String string, LDAPModification[] lDAPModificationArray, LDAPControl[] lDAPControlArray) throws IOException {
        int n = lDAPModificationArray.length;
        this.writeDN(string);
        if (lDAPControlArray != null) {
            this.writeControls(lDAPControlArray);
        }
        this.writeLine("changetype: modify");
        for (int i = 0; i < n; ++i) {
            int n2 = lDAPModificationArray[i].getOp();
            LDAPAttribute lDAPAttribute = lDAPModificationArray[i].getAttribute();
            String string2 = lDAPAttribute.getName();
            byte[][] byArray = lDAPAttribute.getByteValueArray();
            switch (n2) {
                case 0: {
                    this.writeLine("add: " + string2);
                    break;
                }
                case 1: {
                    this.writeLine("delete: " + string2);
                    break;
                }
                case 2: {
                    this.writeLine("replace: " + string2);
                    break;
                }
            }
            for (int j = 0; j < byArray.length; ++j) {
                this.writeAttribute(string2, byArray[j]);
            }
            this.writeLine("-");
        }
    }

    private void writeModifyDNRequest(String string, String string2, boolean bl, String string3, LDAPControl[] lDAPControlArray) throws IOException {
        this.writeDN(string);
        if (lDAPControlArray != null) {
            this.writeControls(lDAPControlArray);
        }
        this.writeLine("changetype: moddn");
        this.writeLine(Base64.isLDIFSafe(string2) ? "newrdn: " + string2 : "newrdn:: " + Base64.encode(string2));
        this.writeLine("deleteoldrdn:" + bl);
        if (string3 != null) {
            this.writeLine(Base64.isLDIFSafe(string3) ? "newsuperior: " + string3 : "newsuperior:: " + Base64.encode(string3));
        }
    }

    private void writeDeleteRequest(String string, LDAPControl[] lDAPControlArray) throws IOException {
        this.writeDN(string);
        if (lDAPControlArray != null) {
            this.writeControls(lDAPControlArray);
        }
        this.writeLine("changetype: delete");
    }

    private void writeDN(String string) throws IOException {
        this.writeLine(Base64.isLDIFSafe(string) ? "dn: " + string : "dn:: " + Base64.encode(string));
    }

    private void writeControls(LDAPControl[] lDAPControlArray) throws IOException {
        for (int i = 0; i < lDAPControlArray.length; ++i) {
            byte[] byArray = lDAPControlArray[i].getValue();
            this.writeLine(byArray != null && byArray.length > 0 ? "control: " + lDAPControlArray[i].getID() + " " + lDAPControlArray[i].isCritical() + ":: " + Base64.encode(byArray) : "control: " + lDAPControlArray[i].getID() + " " + lDAPControlArray[i].isCritical());
        }
    }

    private void writeAttribute(String string, String string2) throws IOException {
        if (string2 != null) {
            this.writeLine(Base64.isLDIFSafe(string2) ? string + ": " + string2 : string + ":: " + Base64.encode(string2));
        }
    }

    private void writeAttribute(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            this.writeLine(Base64.isLDIFSafe(byArray) && this.isPrintable(byArray) ? string + ": " + new String(byArray, "UTF-8") : string + ":: " + Base64.encode(byArray));
        }
    }

    public void finish() throws IOException {
        this.bufWriter.flush();
    }
}

