/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.util.LDAPXMLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventMultiplexer
extends DefaultHandler {
    private LDAPXMLHandler defaulthandler;
    private LDAPXMLHandler currenthandler;
    private Stack Handlerstack = new Stack();
    private StringBuffer buffer = new StringBuffer();

    public void setLDAPXMLHandler(LDAPXMLHandler lDAPXMLHandler) {
        this.defaulthandler = lDAPXMLHandler;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        if (this.currenthandler != null) {
            throw new SAXException("Invalid System State,currenthandler not null in endDocument");
        }
        super.endDocument();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!string2.equals(this.currenthandler.getName())) {
            throw new SAXException("Invalid System State");
        }
        this.currenthandler.value(this.buffer);
        this.buffer.delete(0, this.buffer.length());
        this.currenthandler.endElement();
        this.currenthandler = (LDAPXMLHandler)this.Handlerstack.pop();
        super.endElement(string, string2, string3);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.defaulthandler == null) {
            throw new IllegalArgumentException("Illegal Argument , Default Handler not set");
        }
        this.currenthandler = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        this.Handlerstack.push(this.currenthandler);
        this.currenthandler = this.currenthandler == null ? this.defaulthandler : this.currenthandler.nextHandler(string2);
        if (!string2.equals(this.currenthandler.getName())) {
            throw new SAXException("Unknown tag:" + string2);
        }
        this.currenthandler.startElement();
        this.currenthandler.handleAttributes(attributes);
    }

    public Object parseXML(InputStream inputStream) throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream));
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new IOException("The SAX parser factory is configured incorrectly:" + factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("The SAX parser is configured incorrectly:" + parserConfigurationException);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IOException("The XML cannot be parsed is configured incorrectly:" + sAXNotRecognizedException);
        }
        catch (SAXException sAXException) {
            throw new IOException("The XML cannot be parsed is configured incorrectly:" + sAXException);
        }
        return this.defaulthandler.getObject();
    }
}

