/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;

public class JsonSerializerImpl
extends AbstractGenerator {
    private static final byte[] CHAR_TYPES;
    private static final byte CHAR_OTHER = 0;
    private static final byte CHAR_CONTROL = 1;
    private static final byte CHAR_LF = 2;
    private static final byte CHAR_QUOTATION = 3;
    private static final byte CHAR_REVERSE_SOLIDUS = 4;
    private static final byte CHAR_SURROGATE = 5;
    private static final byte CHAR_BACKSPACE = 6;
    private static final byte CHAR_FORMFEED = 7;
    private static final byte CHAR_CR = 8;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_ASCII = 10;
    private static final int ASCII_MAX = 127;
    private JsonOutput writer;
    private StreamContext ctx;

    public JsonSerializerImpl(OutputStream outputStream) {
        this.writer = new UTF8JsonOutput(outputStream);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    public JsonSerializerImpl(Writer writer) {
        this.writer = new WriterJsonOutput(writer);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.writeSeparator();
        this.ctx.startObject();
        this.writeAscii('{');
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.writeSeparator();
        this.ctx.startArray();
        this.writeAscii('[');
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        if (this.ctx.inObject()) {
            this.ctx.end();
            this.writeAscii('}');
        } else {
            this.ctx.end();
            this.writeAscii(']');
        }
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string) {
        this.primitive();
        JsonSerializerImpl.writeQuotedString(string, this.writer, this.getExceptionFactory());
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String string) {
        this.writeSeparator();
        this.ctx.pendingKey();
        JsonSerializerImpl.writeQuotedString(string, this.writer, this.getExceptionFactory());
        this.writeAscii(':');
        return this;
    }

    private static void writeQuotedString(String string, JsonOutput jsonOutput, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        try {
            jsonOutput.writeAscii((byte)34);
            JsonSerializerImpl.writeEscaped(string, jsonOutput);
            jsonOutput.writeAscii((byte)34);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(exceptionFactory, iOException, new Object[0]);
        }
    }

    public static String serializeString(String string) {
        StringWriter stringWriter = new StringWriter();
        WriterJsonOutput writerJsonOutput = new WriterJsonOutput(stringWriter);
        JsonSerializerImpl.writeQuotedString(string, writerJsonOutput, null);
        try {
            writerJsonOutput.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringWriter.toString();
    }

    @Override
    public OracleJsonGenerator write(BigDecimal bigDecimal) {
        this.primitive();
        this.writeBigDecimal(bigDecimal);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger bigInteger) {
        this.primitive();
        this.writeBigInteger(bigInteger);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int n2) {
        this.primitive();
        this.writeInt(n2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long l2) {
        this.primitive();
        this.writeLong(l2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double d2) {
        this.assertFinite(d2);
        this.primitive();
        this.writeDouble(d2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float f2) {
        this.assertFinite(f2);
        this.primitive();
        this.writeFloat(f2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean bl) {
        this.primitive();
        this.writeBoolean(bl);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.primitive();
        this.writeNullInternal();
        return this;
    }

    @Override
    public void close() {
        this.ctx.close();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    protected OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary oracleJsonBinary) {
        return this.write(((OracleJsonBinaryImpl)oracleJsonBinary).getString());
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble oracleJsonDouble) {
        return this.writeNumber(oracleJsonDouble);
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat oracleJsonFloat) {
        return this.writeNumber(oracleJsonFloat);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal oracleJsonDecimal) {
        return this.writeNumber(oracleJsonDecimal);
    }

    private OracleJsonGenerator writeNumber(OracleJsonNumber oracleJsonNumber) {
        this.primitive();
        try {
            this.writer.writeAscii(this.numberToString(oracleJsonNumber));
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
        return this;
    }

    private String numberToString(OracleJsonNumber oracleJsonNumber) {
        if (oracleJsonNumber instanceof OracleJsonNumberImpl) {
            return ((OracleJsonNumberImpl)((Object)oracleJsonNumber)).getString();
        }
        return oracleJsonNumber.toString();
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp oracleJsonTimestamp) {
        return this.write(((OracleJsonTimestampImpl)oracleJsonTimestamp).getString());
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate oracleJsonDate) {
        return this.write(((OracleJsonDateImpl)oracleJsonDate).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS oracleJsonIntervalDS) {
        return this.write(((OracleJsonIntervalDSImpl)oracleJsonIntervalDS).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM oracleJsonIntervalYM) {
        return this.write(((OracleJsonIntervalYMImpl)oracleJsonIntervalYM).getString());
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString oracleJsonString) {
        return this.write(oracleJsonString.getString());
    }

    private void writeAscii(CharSequence charSequence) {
        try {
            this.writer.writeAscii(charSequence);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    private void writeBigDecimal(BigDecimal bigDecimal) {
        this.writeAscii(bigDecimal.toString());
    }

    private void writeBigInteger(BigInteger bigInteger) {
        this.writeAscii(new BigDecimal(bigInteger).toString());
    }

    private void writeInt(int n2) {
        this.writeAscii(new BigDecimal(n2).toString());
    }

    private void writeLong(long l2) {
        this.writeAscii(new BigDecimal(l2).toString());
    }

    private void writeFloat(float f2) {
        this.writeAscii(Float.toString(f2));
    }

    private void writeDouble(double d2) {
        this.writeAscii(Double.toString(d2));
    }

    private void writeBoolean(boolean bl) {
        this.writeAscii(String.valueOf(bl));
    }

    private void writeNullInternal() {
        this.writeAscii("null");
    }

    private void writeAscii(char c2) {
        try {
            this.writer.writeAscii((byte)c2);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    private void primitive() {
        this.writeSeparator();
        this.ctx.primitive();
    }

    private void writeSeparator() {
        if (this.ctx.hasChildren() && !this.ctx.pendingKey) {
            this.writeAscii(',');
        }
    }

    private static void writeEscaped(String string, JsonOutput jsonOutput) throws IOException {
        int n2 = string.length();
        block13: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (CHAR_TYPES[c2]) {
                case 10: {
                    jsonOutput.writeAscii((byte)c2);
                    continue block13;
                }
                case 0: {
                    jsonOutput.write(c2);
                    continue block13;
                }
                case 2: {
                    jsonOutput.writeAscii("\\n");
                    continue block13;
                }
                case 6: {
                    jsonOutput.writeAscii("\\b");
                    continue block13;
                }
                case 7: {
                    jsonOutput.writeAscii("\\f");
                    continue block13;
                }
                case 8: {
                    jsonOutput.writeAscii("\\r");
                    continue block13;
                }
                case 9: {
                    jsonOutput.writeAscii("\\t");
                    continue block13;
                }
                case 3: {
                    jsonOutput.writeAscii("\\\"");
                    continue block13;
                }
                case 4: {
                    jsonOutput.writeAscii("\\\\");
                    continue block13;
                }
                case 1: {
                    JsonSerializerImpl.escape(c2, jsonOutput);
                    continue block13;
                }
                case 5: {
                    jsonOutput.writeSurrogates(string.charAt(i2), string.charAt(i2 + 1));
                    ++i2;
                }
            }
        }
    }

    private void assertFinite(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new NumberFormatException(Double.toString(d2));
        }
    }

    private static void escape(int n2, JsonOutput jsonOutput) throws IOException {
        for (char c2 : Character.toChars(n2)) {
            String string = Integer.toHexString(c2).toUpperCase();
            jsonOutput.writeAscii("\\u");
            for (int i2 = 0; i2 < 4 - string.length(); ++i2) {
                jsonOutput.writeAscii((byte)48);
            }
            jsonOutput.writeAscii(string);
        }
    }

    @Override
    public OracleJsonGenerator write(String string, Instant instant) {
        this.writeKey(string);
        this.write(instant);
        return this;
    }

    @Override
    public OracleJsonGenerator write(Instant instant) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestamp(this.getExceptionFactory(), localDateTime);
        this.write(OsonPrimitiveConversions.timestampToString(this.getExceptionFactory(), byArray));
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, byte[] byArray) {
        this.writeKey(string);
        this.write(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] byArray) {
        return this.write(OracleJsonBinaryImpl.getString(byArray, false));
    }

    @Override
    public OracleJsonGenerator writeId(byte[] byArray) {
        return this.write(OracleJsonBinaryImpl.getString(byArray, true));
    }

    @Override
    public OracleJsonGenerator write(Period period) {
        return this.write(OracleJsonIntervalYMImpl.serializePeriod(period, this.getExceptionFactory()));
    }

    @Override
    public OracleJsonGenerator write(Duration duration) {
        return this.write(OracleJsonIntervalDSImpl.serializeDuration(duration, this.getExceptionFactory()));
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser oracleJsonParser) {
        if (!this.writer.utf8() || !(oracleJsonParser instanceof OsonParserImpl)) {
            this.write(oracleJsonParser.getString());
            return;
        }
        this.primitive();
        OsonParserImpl osonParserImpl = (OsonParserImpl)oracleJsonParser;
        byte[] byArray = osonParserImpl.getContext().b.buffer.array();
        this.writeQuotedUTF8String(byArray, osonParserImpl.getCurrentStringPos(), osonParserImpl.getCurrentStringLen());
    }

    private void writeQuotedUTF8String(byte[] byArray, int n2, int n3) {
        try {
            this.writeAscii('\"');
            int n4 = n2 + n3;
            block13: for (int i2 = n2; i2 < n4; ++i2) {
                byte by = byArray[i2];
                switch (CHAR_TYPES[by & 0xFF]) {
                    case 10: {
                        this.writer.writeAscii(by);
                        continue block13;
                    }
                    case 2: {
                        this.writer.writeAscii("\\n");
                        continue block13;
                    }
                    case 6: {
                        this.writer.writeAscii("\\b");
                        continue block13;
                    }
                    case 7: {
                        this.writer.writeAscii("\\f");
                        continue block13;
                    }
                    case 8: {
                        this.writer.writeAscii("\\r");
                        continue block13;
                    }
                    case 9: {
                        this.writer.writeAscii("\\t");
                        continue block13;
                    }
                    case 3: {
                        this.writer.writeAscii("\\\"");
                        continue block13;
                    }
                    case 4: {
                        this.writer.writeAscii("\\\\");
                        continue block13;
                    }
                    case 1: {
                        JsonSerializerImpl.escape(by, this.writer);
                        continue block13;
                    }
                    default: {
                        if ((by & 0xE0) == 192) {
                            this.writer.utf8(byArray, i2, 2);
                            ++i2;
                            continue block13;
                        }
                        if ((by & 0xF0) == 224) {
                            this.writer.utf8(byArray, i2, 3);
                            i2 += 2;
                            continue block13;
                        }
                        this.writer.utf8(byArray, i2, 4);
                        i2 += 3;
                    }
                }
            }
            this.writeAscii('\"');
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser oracleJsonParser) {
        this.primitive();
        try {
            this.writer.writeAscii(oracleJsonParser.getString());
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    static {
        int n2;
        CHAR_TYPES = new byte[65536];
        for (n2 = 0; n2 <= 127; ++n2) {
            JsonSerializerImpl.CHAR_TYPES[n2] = 10;
        }
        for (n2 = 0; n2 <= 31; n2 = (int)((char)(n2 + 1))) {
            JsonSerializerImpl.CHAR_TYPES[n2] = 1;
        }
        JsonSerializerImpl.CHAR_TYPES[127] = 1;
        JsonSerializerImpl.CHAR_TYPES[10] = 2;
        JsonSerializerImpl.CHAR_TYPES[92] = 4;
        JsonSerializerImpl.CHAR_TYPES[34] = 3;
        JsonSerializerImpl.CHAR_TYPES[8] = 6;
        JsonSerializerImpl.CHAR_TYPES[12] = 7;
        JsonSerializerImpl.CHAR_TYPES[13] = 8;
        JsonSerializerImpl.CHAR_TYPES[9] = 9;
        for (n2 = 55296; n2 <= 56319; n2 = (int)((char)(n2 + 1))) {
            JsonSerializerImpl.CHAR_TYPES[n2] = 5;
        }
    }

    private static class UTF8JsonOutput
    implements JsonOutput {
        byte[] buffer = new byte[1024];
        OutputStream out;
        int pos = 0;
        CharsetEncoder encoder;
        CharBuffer cbuffer;

        public UTF8JsonOutput(OutputStream outputStream) {
            this.out = outputStream;
        }

        private void initEncoder() {
            if (this.encoder == null) {
                this.encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.cbuffer = CharBuffer.allocate(2);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
            this.buffer = null;
        }

        @Override
        public void writeAscii(CharSequence charSequence) throws IOException {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = (byte)charSequence.charAt(i2);
            }
        }

        @Override
        public void writeAscii(byte by) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = by;
        }

        @Override
        public void flush() throws IOException {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void write(char c2) throws IOException {
            if (c2 <= '\u007f') {
                this.writeAscii((byte)c2);
            } else {
                this.flush();
                this.initEncoder();
                this.cbuffer.clear();
                this.cbuffer.append(c2);
                this.cbuffer.flip();
                this.encodeChars();
            }
        }

        @Override
        public void writeSurrogates(char c2, char c3) throws IOException {
            this.flush();
            this.initEncoder();
            this.cbuffer.clear();
            this.cbuffer.append(c2);
            this.cbuffer.append(c3);
            this.cbuffer.flip();
            this.encodeChars();
        }

        @Override
        public boolean utf8() {
            return true;
        }

        private void encodeChars() {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer);
            this.encoder.encode(this.cbuffer, byteBuffer, false);
            this.pos = byteBuffer.position();
        }

        @Override
        public void utf8(byte[] byArray, int n2, int n3) throws IOException {
            this.flush();
            this.out.write(byArray, n2, n3);
        }
    }

    private static final class WriterJsonOutput
    implements JsonOutput {
        char[] buffer = new char[1024];
        int pos = 0;
        Writer writer;

        WriterJsonOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.writer.close();
            this.buffer = null;
        }

        @Override
        public void flush() throws IOException {
            this.writer.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void writeAscii(CharSequence charSequence) throws IOException {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = charSequence.charAt(i2);
            }
        }

        @Override
        public void writeAscii(byte by) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = (char)by;
        }

        @Override
        public void write(char c2) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = c2;
        }

        @Override
        public void writeSurrogates(char c2, char c3) throws IOException {
            this.write(c2);
            this.write(c3);
        }

        @Override
        public boolean utf8() {
            return false;
        }

        @Override
        public void utf8(byte[] byArray, int n2, int n3) throws IOException {
            this.flush();
            this.writer.write(new String(byArray, n2, n3, StandardCharsets.UTF_8));
        }
    }

    private static interface JsonOutput
    extends Closeable {
        public void flush() throws IOException;

        public void write(char var1) throws IOException;

        public void writeAscii(CharSequence var1) throws IOException;

        public void writeAscii(byte var1) throws IOException;

        public void writeSurrogates(char var1, char var2) throws IOException;

        public boolean utf8();

        public void utf8(byte[] var1, int var2, int var3) throws IOException;
    }
}

