/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.annotation.JsonProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface PropertyNameResolver {
    public String resolve(int var1, Constructor<?> var2);

    public String resolve(int var1, Method var2);

    public String resolve(Field var1);

    public String resolve(Method var1);

    public static class AnnotationPropertyNameResolver
    implements PropertyNameResolver {
        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            Annotation[] paramAnns = fromConstructor.getParameterAnnotations()[parameterIdx];
            String name = null;
            for (int j = 0; j < paramAnns.length; ++j) {
                if (!(paramAnns[j] instanceof JsonProperty)) continue;
                name = ((JsonProperty)paramAnns[j]).value();
                break;
            }
            return "".equals(name) ? null : name;
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            Annotation[] anns = fromMethod.getParameterAnnotations()[parameterIdx];
            String name = null;
            for (Annotation ann : anns) {
                if (!(ann instanceof JsonProperty)) continue;
                name = ((JsonProperty)ann).value();
                break;
            }
            return "".equals(name) ? null : name;
        }

        @Override
        public String resolve(Field fromField) {
            return this.getName(fromField);
        }

        @Override
        public String resolve(Method fromMethod) {
            return this.getName(fromMethod);
        }

        protected String getName(AnnotatedElement annElement) {
            JsonProperty name = annElement.getAnnotation(JsonProperty.class);
            return name != null && name.value() != null && !name.value().isEmpty() ? name.value() : null;
        }
    }

    public static class ConventionalBeanPropertyNameResolver
    implements PropertyNameResolver {
        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            return null;
        }

        @Override
        public String resolve(Field fromField) {
            return fromField.getName();
        }

        @Override
        public String resolve(Method fromMethod) {
            String name = fromMethod.getName();
            int length = -1;
            if (name.startsWith("get")) {
                length = 3;
            } else if (name.startsWith("is")) {
                length = 2;
            } else if (name.startsWith("set")) {
                length = 3;
            }
            if (length > -1) {
                return Character.toLowerCase(name.charAt(length)) + name.substring(length + 1);
            }
            return null;
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            return null;
        }
    }

    public static class CompositePropertyNameResolver
    implements PropertyNameResolver {
        private List<PropertyNameResolver> components;

        public CompositePropertyNameResolver(List<PropertyNameResolver> components) {
            if (components == null || components.isEmpty()) {
                throw new IllegalArgumentException("The composite resolver must have at least one resolver as component!");
            }
            this.components = new LinkedList<PropertyNameResolver>(components);
        }

        public CompositePropertyNameResolver add(PropertyNameResolver ... resolvers) {
            this.components.addAll(0, Arrays.asList(resolvers));
            return this;
        }

        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(parameterIdx, fromConstructor);
            }
            return resolvedName;
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(parameterIdx, fromMethod);
            }
            return resolvedName;
        }

        @Override
        public String resolve(Field fromField) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(fromField);
            }
            return resolvedName;
        }

        @Override
        public String resolve(Method fromMethod) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(fromMethod);
            }
            return resolvedName;
        }
    }
}

