/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.scp;

import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.IOUtils;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.scp.DestinationOs;
import com.pastdev.jsch.scp.ScpEntry;
import com.pastdev.jsch.scp.ScpFileInputStream;
import com.pastdev.jsch.scp.ScpFileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ScpFile {
    private DestinationOs os;
    private String[] path;
    private SessionFactory sessionFactory;

    public ScpFile(SessionFactory sessionFactory, String ... path) {
        this(sessionFactory, DestinationOs.UNIX, path);
    }

    public ScpFile(SessionFactory sessionFactory, DestinationOs os, String ... path) {
        this.sessionFactory = sessionFactory;
        this.os = os;
        this.path = path;
    }

    public void copyFrom(File file) throws IOException, JSchException {
        this.copyFrom(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(File file, String mode) throws IOException, JSchException {
        ScpFileOutputStream to;
        block5: {
            FileInputStream from = null;
            to = null;
            try {
                from = new FileInputStream(file);
                to = mode == null ? this.getOutputStream(file.length()) : this.getOutputStream(file.length(), mode);
                IOUtils.copy(from, to);
                if (from == null) break block5;
            }
            catch (Throwable throwable) {
                if (from != null) {
                    IOUtils.closeAndLogException(from);
                }
                if (to != null) {
                    IOUtils.closeAndLogException(to);
                }
                throw throwable;
            }
            IOUtils.closeAndLogException(from);
        }
        if (to != null) {
            IOUtils.closeAndLogException(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(File file) throws JSchException, IOException {
        FileOutputStream to;
        block15: {
            ScpFileInputStream from = null;
            to = null;
            try {
                from = this.getInputStream();
                String name = from.getName();
                String mode = from.getMode();
                if (file.isDirectory()) {
                    file = new File(file, name);
                }
                to = new FileOutputStream(file);
                int userPerm = Character.getNumericValue(mode.charAt(1));
                int otherPerm = Character.getNumericValue(mode.charAt(3));
                if ((userPerm & 1) == 1) {
                    if ((otherPerm & 1) == 1) {
                        file.setExecutable(true, false);
                    } else {
                        file.setExecutable(true, true);
                    }
                }
                if ((userPerm & 2) == 2) {
                    if ((otherPerm & 2) == 2) {
                        file.setWritable(true, false);
                    } else {
                        file.setWritable(true, true);
                    }
                }
                if ((userPerm & 4) == 4) {
                    if ((otherPerm & 4) == 4) {
                        file.setReadable(true, false);
                    } else {
                        file.setReadable(true, true);
                    }
                }
                IOUtils.copy(from, to);
                if (from == null) break block15;
            }
            catch (Throwable throwable) {
                if (from != null) {
                    IOUtils.closeAndLogException(from);
                }
                if (to != null) {
                    IOUtils.closeAndLogException(to);
                }
                throw throwable;
            }
            IOUtils.closeAndLogException(from);
        }
        if (to != null) {
            IOUtils.closeAndLogException(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ScpFile file) throws JSchException, IOException {
        ScpFileOutputStream to;
        block5: {
            ScpFileInputStream from = null;
            to = null;
            try {
                from = this.getInputStream();
                String mode = from.getMode();
                long size = from.getSize();
                to = file.getOutputStream(size, mode);
                IOUtils.copy(from, to);
                if (from == null) break block5;
            }
            catch (Throwable throwable) {
                if (from != null) {
                    IOUtils.closeAndLogException(from);
                }
                if (to != null) {
                    IOUtils.closeAndLogException(to);
                }
                throw throwable;
            }
            IOUtils.closeAndLogException(from);
        }
        if (to != null) {
            IOUtils.closeAndLogException(to);
        }
    }

    public ScpFileInputStream getInputStream() throws JSchException, IOException {
        return new ScpFileInputStream(this.sessionFactory, this.getPath());
    }

    public ScpFileOutputStream getOutputStream(long size) throws JSchException, IOException {
        return this.getOutputStream(ScpEntry.newFile(this.getFilename(), size));
    }

    public ScpFileOutputStream getOutputStream(long size, String mode) throws JSchException, IOException {
        return this.getOutputStream(ScpEntry.newFile(this.getFilename(), size, mode));
    }

    private ScpFileOutputStream getOutputStream(ScpEntry scpEntry) throws JSchException, IOException {
        return new ScpFileOutputStream(this.sessionFactory, this.getDirectory(), scpEntry);
    }

    String getDirectory() {
        return this.os.joinPath(this.path, 0, this.path.length - 1);
    }

    String getFilename() {
        return this.path[this.path.length - 1];
    }

    String getPath() {
        return this.os.joinPath(this.path, 0, this.path.length);
    }
}

