/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractHeaderCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private static final Pattern ESCAPED_LINE_FEED_PATTERN = Pattern.compile("\\\\n");
    private final List<String> readerLines = Lists.newArrayList();
    private String headerFile;
    private String charset = System.getProperty("file.encoding", "UTF-8");

    protected abstract void postProcessHeaderLines();

    protected ImmutableList<String> getHeaderLines() {
        return ImmutableList.copyOf(this.readerLines);
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }

    public void setHeaderFile(String fileName) throws CheckstyleException {
        if (CommonUtils.isBlank(fileName)) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
        this.headerFile = fileName;
    }

    private void loadHeaderFile() throws CheckstyleException {
        this.checkHeaderNotInitialized();
        InputStreamReader headerReader = null;
        try {
            URI uri = CommonUtils.getUriByFilename(this.headerFile);
            headerReader = new InputStreamReader((InputStream)new BufferedInputStream(uri.toURL().openStream()), this.charset);
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            try {
                throw new CheckstyleException("unable to load header file " + this.headerFile, ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(headerReader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)headerReader);
    }

    private void checkHeaderNotInitialized() {
        if (!this.readerLines.isEmpty()) {
            throw new ConversionException("header has already been set - set either header or headerFile, not both");
        }
    }

    public void setHeader(String header) {
        if (!CommonUtils.isBlank(header)) {
            this.checkHeaderNotInitialized();
            String headerExpandedNewLines = ESCAPED_LINE_FEED_PATTERN.matcher(header).replaceAll("\n");
            StringReader headerReader = new StringReader(headerExpandedNewLines);
            try {
                this.loadHeader(headerReader);
            }
            catch (IOException ex) {
                throw new ConversionException("unable to load header", (Throwable)ex);
            }
            finally {
                Closeables.closeQuietly((Reader)headerReader);
            }
        }
    }

    private void loadHeader(Reader headerReader) throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(headerReader);
        this.readerLines.clear();
        while ((line = lnr.readLine()) != null) {
            this.readerLines.add(line);
        }
        this.postProcessHeaderLines();
    }

    @Override
    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.headerFile != null) {
            this.loadHeaderFile();
        }
        if (this.readerLines.isEmpty()) {
            this.setHeader(null);
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return ImmutableSet.of((Object)this.headerFile);
    }
}

