/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class VictimsService {
    protected String baseURI = VictimsConfig.uri();
    protected String serviceEntry = VictimsConfig.entry();

    public RecordStream updates(Date since) throws IOException {
        return this.fetch(since, "update");
    }

    public RecordStream removed(Date since) throws IOException {
        return this.fetch(since, "remove");
    }

    protected RecordStream fetch(Date since, String type) throws IOException {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String spec = FileUtils.getFile((String[])new String[]{this.serviceEntry, type, fmt.format(since)}).toString();
        spec = FilenameUtils.normalize((String)spec, (boolean)true);
        URL merged = new URL(new URL(this.baseURI), spec);
        return new RecordStream(merged.toString());
    }

    public static class RecordStream {
        protected JsonReader json;
        protected InputStream in;
        protected Gson gson;

        public RecordStream(String uri) throws IOException {
            this(new URL(uri).openStream());
        }

        public RecordStream(InputStream in) throws IOException {
            this.in = in;
            this.gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
            this.json = new JsonReader((Reader)new InputStreamReader(in, "UTF-8"));
            this.json.beginArray();
        }

        public VictimsRecord getNext() throws IOException {
            if (this.hasNext()) {
                this.json.beginObject();
                this.json.nextName();
                VictimsRecord v = (VictimsRecord)this.gson.fromJson(this.json, VictimsRecord.class);
                this.json.endObject();
                return v;
            }
            return null;
        }

        public boolean hasNext() throws IOException {
            if (!this.json.hasNext()) {
                this.json.endArray();
                IOUtils.closeQuietly((InputStream)this.in);
                return false;
            }
            return true;
        }
    }
}

