/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.database;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsException;
import com.redhat.victims.database.VictimsDBInterface;
import com.redhat.victims.database.VictimsSqlDB;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;

public class VictimsDB {
    public static String defaultDriver() {
        return "org.h2.Driver";
    }

    public static String defaultURL(String driver) {
        assert (Driver.exists(driver));
        String home = "";
        try {
            home = VictimsConfig.home().toString();
        }
        catch (VictimsException victimsException) {
            // empty catch block
        }
        return Driver.url(driver, FilenameUtils.concat((String)home, (String)"victims"));
    }

    public static String defaultURL() {
        return VictimsDB.defaultURL(VictimsDB.defaultDriver());
    }

    public static VictimsDBInterface db() throws VictimsException {
        String driver = VictimsConfig.dbDriver();
        String dbUrl = VictimsConfig.dbUrl();
        if (!driver.equals(VictimsDB.defaultDriver()) && !Driver.exists(driver) && dbUrl.equals(VictimsDB.defaultURL())) {
            throw new VictimsException("A custom JDBC driver was specified without setting victims.db.url");
        }
        return new VictimsSqlDB();
    }

    public static class Driver {
        public static final String H2 = "org.h2.Driver";
        public static final HashMap<String, String> urls = new HashMap();

        public static boolean exists(String driver) {
            return urls.containsKey(driver);
        }

        public static String url(String driver, String path) {
            return String.format(urls.get(driver), path);
        }

        public static void addDriver(String driver, String urlFormat) {
            urls.put(driver, urlFormat);
        }

        static {
            urls.put(H2, "jdbc:h2:%s;MVCC=true");
        }
    }
}

