/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.util.FacesLogger;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.convert.FacesConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterConfigHandler
implements ConfigAnnotationHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Collection<Class<? extends Annotation>> HANDLES;
    private Map<Object, String> converters;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> clazz, Annotation annotation) {
        FacesConverter facesConverter;
        if (this.converters == null) {
            this.converters = new HashMap<Object, String>();
        }
        if ((facesConverter = (FacesConverter)annotation).value().length() > 0 && facesConverter.forClass() != null && facesConverter.forClass() != Object.class && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "@FacesConverter is using both value and forClass, only value will be applied.");
        }
        Object object = 0 == facesConverter.value().length() ? facesConverter.forClass() : facesConverter.value();
        this.converters.put(object, clazz.getName());
    }

    @Override
    public void push(FacesContext facesContext) {
        if (this.converters != null) {
            Application application = facesContext.getApplication();
            for (Map.Entry<Object, String> entry : this.converters.entrySet()) {
                if (entry.getKey() instanceof Class) {
                    application.addConverter((Class)entry.getKey(), entry.getValue());
                    continue;
                }
                application.addConverter((String)entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        ArrayList<Class<FacesConverter>> arrayList = new ArrayList<Class<FacesConverter>>(1);
        arrayList.add(FacesConverter.class);
        HANDLES = Collections.unmodifiableCollection(arrayList);
    }
}

