/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentOrderingWrapper {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static Comparator<DocumentOrderingWrapper> COMPARATOR = new DocumentOrderingComparator();
    private static final int MAX_SORT_PASSED = 1000;
    private static final String ORDERING = "ordering";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String NAME = "name";
    private static final String OTHERS = "others";
    private static final String OTHERS_KEY = DocumentOrderingWrapper.class.getName() + ".OTHERS_KEY";
    private static final int SWAP = -1;
    private static final int DO_NOT_SWAP = 0;
    private DocumentInfo documentInfo;
    private String id;
    private String[] beforeIds;
    private String[] afterIds;

    public DocumentOrderingWrapper(DocumentInfo documentInfo) {
        this.documentInfo = documentInfo;
        this.init();
    }

    public DocumentInfo getDocument() {
        return this.documentInfo;
    }

    public String getDocumentId() {
        return this.id;
    }

    public String[] getBeforeIds() {
        return this.beforeIds;
    }

    public String[] getAfterIds() {
        return this.afterIds;
    }

    public boolean isBeforeOrdered() {
        return this.beforeIds.length != 0;
    }

    public boolean isAfterOrdered() {
        return this.afterIds.length != 0;
    }

    public boolean isOrdered() {
        return this.isBeforeOrdered() || this.isAfterOrdered();
    }

    public boolean isBefore(String string) {
        return DocumentOrderingWrapper.search(this.beforeIds, string);
    }

    public boolean isAfter(String string) {
        return DocumentOrderingWrapper.search(this.afterIds, string);
    }

    public boolean isAfterOthers() {
        return DocumentOrderingWrapper.search(this.afterIds, OTHERS_KEY);
    }

    public boolean isBeforeOthers() {
        return DocumentOrderingWrapper.search(this.beforeIds, OTHERS_KEY);
    }

    public String toString() {
        return "Document{id='" + this.id + '\'' + ", beforeIds=" + (this.beforeIds == null ? null : Arrays.asList(this.beforeIds)) + ", afterIds=" + (this.afterIds == null ? null : Arrays.asList(this.afterIds)) + '}';
    }

    public static DocumentOrderingWrapper[] sort(DocumentOrderingWrapper[] documentOrderingWrapperArray, List<String> list) {
        CopyOnWriteArrayList<DocumentOrderingWrapper> copyOnWriteArrayList = new CopyOnWriteArrayList<DocumentOrderingWrapper>();
        copyOnWriteArrayList.addAll(Arrays.asList(documentOrderingWrapperArray));
        ArrayList<DocumentOrderingWrapper> arrayList = new ArrayList<DocumentOrderingWrapper>();
        for (String object : list) {
            if (OTHERS.equals(object)) continue;
            boolean bl = false;
            for (DocumentOrderingWrapper documentOrderingWrapper : copyOnWriteArrayList) {
                if (!bl && object.equals(documentOrderingWrapper.getDocumentId())) {
                    bl = true;
                    arrayList.add(documentOrderingWrapper);
                    copyOnWriteArrayList.remove(documentOrderingWrapper);
                    continue;
                }
                if (!bl || !object.equals(documentOrderingWrapper.getDocumentId())) continue;
                if (!LOGGER.isLoggable(Level.WARNING)) break;
                LOGGER.log(Level.WARNING, "jsf.configuration.absolute.order.duplicate.document", new Object[]{object});
                break;
            }
            if (bl || !LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.log(Level.WARNING, "jsf.configuration.absolute.order.missing.document", new Object[]{object});
        }
        int n = list.indexOf(OTHERS);
        if (n != -1) {
            for (DocumentOrderingWrapper documentOrderingWrapper : copyOnWriteArrayList) {
                arrayList.add(n, documentOrderingWrapper);
            }
        }
        return arrayList.toArray(new DocumentOrderingWrapper[arrayList.size()]);
    }

    public static void sort(DocumentOrderingWrapper[] documentOrderingWrapperArray) {
        Timer timer = Timer.getInstance();
        if (timer != null) {
            timer.startTiming();
        }
        try {
            DocumentOrderingWrapper.enhanceOrderingData(documentOrderingWrapperArray);
        }
        catch (CircularDependencyException circularDependencyException) {
            String string = "Circular dependencies detected!\nDocument Info\n==================\n";
            for (DocumentOrderingWrapper documentOrderingWrapper : documentOrderingWrapperArray) {
                string = string + "  " + documentOrderingWrapper.toString() + '\n';
            }
            throw new ConfigurationException(string);
        }
        boolean bl = true;
        int n = 0;
        while (bl) {
            if (++n == 1000) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    String string = "Exceeded maximum number of attempts to sort the application's faces-config documents.\nDocument Info\n==================";
                    for (DocumentOrderingWrapper documentOrderingWrapper : documentOrderingWrapperArray) {
                        string = string + "  " + documentOrderingWrapper.toString() + '\n';
                    }
                    LOGGER.severe(string);
                }
                throw new ConfigurationException("Exceeded maximum number of attempts to sort the faces-config documents.");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Starting sort pass number {0}...", n);
            }
            bl = false;
            for (int i = 0; i < documentOrderingWrapperArray.length - 1; ++i) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Comparing {0}, {1}", new Object[]{documentOrderingWrapperArray[i].id, documentOrderingWrapperArray[i + 1].id});
                }
                if (COMPARATOR.compare(documentOrderingWrapperArray[i], documentOrderingWrapperArray[i + 1]) == 0) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Swapping {0} with {1}", new Object[]{documentOrderingWrapperArray[i].id, documentOrderingWrapperArray[i + 1].id});
                }
                DocumentOrderingWrapper object = documentOrderingWrapperArray[i];
                documentOrderingWrapperArray[i] = documentOrderingWrapperArray[i + 1];
                documentOrderingWrapperArray[i + 1] = object;
                bl = true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Comparing {0}, {1}", new Object[]{documentOrderingWrapperArray[0].id, documentOrderingWrapperArray[documentOrderingWrapperArray.length - 1].id});
            }
            if (COMPARATOR.compare(documentOrderingWrapperArray[0], documentOrderingWrapperArray[documentOrderingWrapperArray.length - 1]) == 0) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Swapping {0} with {1}", new Object[]{documentOrderingWrapperArray[0].id, documentOrderingWrapperArray[documentOrderingWrapperArray.length - 1].id});
            }
            DocumentOrderingWrapper documentOrderingWrapper = documentOrderingWrapperArray[0];
            documentOrderingWrapperArray[0] = documentOrderingWrapperArray[documentOrderingWrapperArray.length - 1];
            documentOrderingWrapperArray[documentOrderingWrapperArray.length - 1] = documentOrderingWrapper;
            bl = true;
        }
        if (timer != null) {
            timer.stopTiming();
            timer.logResult("\"faces-config\" document sorting complete in " + n + '.');
        }
    }

    private static void enhanceOrderingData(DocumentOrderingWrapper[] documentOrderingWrapperArray) throws CircularDependencyException {
        for (int i = 0; i < documentOrderingWrapperArray.length; ++i) {
            Object[] objectArray;
            HashSet<Object> hashSet;
            String[] stringArray;
            Object object;
            Object[] objectArray2;
            DocumentOrderingWrapper documentOrderingWrapper;
            int n;
            DocumentOrderingWrapper documentOrderingWrapper2 = documentOrderingWrapperArray[i];
            for (String string : documentOrderingWrapper2.getBeforeIds()) {
                if (OTHERS_KEY.equals(string)) continue;
                for (n = 0; n < documentOrderingWrapperArray.length; ++n) {
                    documentOrderingWrapper = documentOrderingWrapperArray[n];
                    if (!string.equals(documentOrderingWrapper.id)) continue;
                    objectArray2 = documentOrderingWrapper.getAfterIds();
                    if (Arrays.binarySearch(objectArray2, documentOrderingWrapper2.id) < 0) {
                        object = new HashSet(objectArray2.length + 1);
                        object.addAll(Arrays.asList(objectArray2));
                        object.add(documentOrderingWrapper2.id);
                        documentOrderingWrapper.afterIds = object.toArray(new String[object.size()]);
                        Arrays.sort(documentOrderingWrapper.afterIds);
                    }
                    if (((String[])(object = documentOrderingWrapper.getBeforeIds())).length <= 0) continue;
                    stringArray = documentOrderingWrapper2.getBeforeIds();
                    hashSet = new HashSet<Object>();
                    hashSet.addAll(Arrays.asList(stringArray));
                    for (Object object2 : object) {
                        if (OTHERS_KEY.equals(object2)) continue;
                        hashSet.add(object2);
                    }
                    objectArray = hashSet.toArray(new String[hashSet.size()]);
                    Arrays.sort(objectArray);
                    if (DocumentOrderingWrapper.search((String[])objectArray, documentOrderingWrapper2.id)) {
                        throw new CircularDependencyException();
                    }
                    documentOrderingWrapper2.beforeIds = objectArray;
                }
            }
            for (String string : documentOrderingWrapper2.getAfterIds()) {
                if (OTHERS_KEY.equals(string)) continue;
                for (n = 0; n < documentOrderingWrapperArray.length; ++n) {
                    documentOrderingWrapper = documentOrderingWrapperArray[n];
                    if (!string.equals(documentOrderingWrapper.id)) continue;
                    objectArray2 = documentOrderingWrapper.getBeforeIds();
                    if (Arrays.binarySearch(objectArray2, documentOrderingWrapper2.id) < 0) {
                        object = new HashSet(objectArray2.length + 1);
                        object.addAll(Arrays.asList(objectArray2));
                        object.add(documentOrderingWrapper2.id);
                        documentOrderingWrapper.beforeIds = object.toArray(new String[object.size()]);
                        Arrays.sort(documentOrderingWrapper.beforeIds);
                    }
                    if (((Object)(object = documentOrderingWrapper.getAfterIds())).length <= 0) continue;
                    stringArray = documentOrderingWrapper2.getAfterIds();
                    hashSet = new HashSet();
                    hashSet.addAll(Arrays.asList(stringArray));
                    for (Object object2 : object) {
                        if (OTHERS_KEY.equals(object2)) continue;
                        hashSet.add(object2);
                    }
                    objectArray = hashSet.toArray(new String[hashSet.size()]);
                    Arrays.sort(objectArray);
                    if (DocumentOrderingWrapper.search((String[])objectArray, documentOrderingWrapper2.id)) {
                        throw new CircularDependencyException();
                    }
                    documentOrderingWrapper2.afterIds = objectArray;
                }
            }
        }
    }

    private static boolean search(String[] stringArray, String string) {
        return Arrays.binarySearch(stringArray, string) >= 0;
    }

    private void init() {
        Element element = this.documentInfo.getDocument().getDocumentElement();
        String string = element.getNamespaceURI();
        this.id = this.getDocumentName(element);
        NodeList nodeList = element.getElementsByTagNameNS(string, ORDERING);
        Set<String> set = null;
        Set<String> set2 = null;
        if (nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node2 = nodeList2.item(j);
                    if (set == null) {
                        set = this.extractIds(node2, BEFORE);
                    }
                    if (set2 != null) continue;
                    set2 = this.extractIds(node2, AFTER);
                }
            }
        }
        this.beforeIds = set != null ? set.toArray(new String[set.size()]) : new String[]{};
        this.afterIds = set2 != null ? set2.toArray(new String[set2.size()]) : new String[]{};
        Arrays.sort(this.beforeIds);
        Arrays.sort(this.afterIds);
        this.checkDuplicates(this.beforeIds, this.afterIds);
        this.checkDuplicates(this.afterIds, this.beforeIds);
    }

    private String getDocumentName(Element element) {
        NodeList nodeList = element.getChildNodes();
        String string = "";
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!NAME.equals(node.getLocalName())) continue;
                string = this.getNodeText(node);
                break;
            }
        }
        return string;
    }

    private void checkDuplicates(String[] stringArray, String[] stringArray2) {
        for (String string : stringArray) {
            if (!DocumentOrderingWrapper.search(stringArray2, string)) continue;
            String string2 = MessageFormat.format("Document {0} is specified to come before and after {1}.", this.documentInfo.getDocument().getDocumentURI(), string);
            throw new ConfigurationException(string2);
        }
    }

    private Set<String> extractIds(Node node, String string) {
        HashSet<String> hashSet = null;
        if (string.equals(node.getLocalName())) {
            hashSet = new HashSet<String>();
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                Node node2 = nodeList.item(i);
                if (NAME.equals(node2.getLocalName()) && (string2 = this.getNodeText(node2)) != null) {
                    hashSet.add(string2);
                }
                if (!OTHERS.equals(node2.getLocalName()) || this.id == null) continue;
                hashSet.add(OTHERS_KEY);
            }
        }
        return hashSet;
    }

    private String getNodeText(Node node) {
        String string = null;
        if (node != null && (string = node.getTextContent()) != null) {
            string = string.trim();
        }
        return string != null && string.length() != 0 ? string : null;
    }

    private static final class CircularDependencyException
    extends Exception {
        public CircularDependencyException() {
        }

        public CircularDependencyException(String string) {
            super(string);
        }

        public CircularDependencyException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public CircularDependencyException(Throwable throwable) {
            super(throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DocumentOrderingComparator
    implements Comparator<DocumentOrderingWrapper> {
        private DocumentOrderingComparator() {
        }

        @Override
        public int compare(DocumentOrderingWrapper documentOrderingWrapper, DocumentOrderingWrapper documentOrderingWrapper2) {
            String string = documentOrderingWrapper.id;
            String string2 = documentOrderingWrapper2.id;
            boolean bl = documentOrderingWrapper.isOrdered();
            boolean bl2 = documentOrderingWrapper2.isOrdered();
            if (bl && !bl2 && documentOrderingWrapper.isAfterOrdered() && !documentOrderingWrapper.isBeforeOthers()) {
                return -1;
            }
            boolean bl3 = documentOrderingWrapper2.isBefore(string);
            boolean bl4 = documentOrderingWrapper.isAfter(string2);
            if (bl3 || bl4) {
                return -1;
            }
            boolean bl5 = documentOrderingWrapper.isAfterOthers();
            if (!(!bl5 || documentOrderingWrapper.isBefore(string2) || documentOrderingWrapper.isAfterOthers() && documentOrderingWrapper2.isAfterOthers())) {
                return -1;
            }
            boolean bl6 = documentOrderingWrapper2.isBeforeOthers();
            if (!(!bl6 || documentOrderingWrapper2.isAfter(string) || documentOrderingWrapper.isBeforeOthers() && documentOrderingWrapper2.isBeforeOthers())) {
                return -1;
            }
            return 0;
        }
    }
}

