/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.FaceletViewHandlingStrategy;
import com.sun.faces.config.FaceletsConfiguration;
import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.lifecycle.HttpMethodRestrictionsPhaseListener;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebConfiguration {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern ALLOWABLE_BOOLEANS = Pattern.compile("true|false", 2);
    private static final String WEB_CONFIG_KEY = "com.sun.faces.config.WebConfiguration";
    public static final String META_INF_CONTRACTS_DIR = "META-INF" + WebContextInitParameter.WebAppContractsDirectory.getDefaultValue();
    private static final int META_INF_CONTRACTS_DIR_LEN = META_INF_CONTRACTS_DIR.length();
    private static final String RESOURCE_CONTRACT_SUFFIX = "/javax.faces.contract.xml";
    private Level loggingLevel = Level.FINE;
    private Map<BooleanWebContextInitParameter, Boolean> booleanContextParameters = new EnumMap<BooleanWebContextInitParameter, Boolean>(BooleanWebContextInitParameter.class);
    private Map<WebContextInitParameter, String> contextParameters = new EnumMap<WebContextInitParameter, String>(WebContextInitParameter.class);
    private Map<WebContextInitParameter, Map<String, String>> facesConfigParameters = new EnumMap<WebContextInitParameter, Map<String, String>>(WebContextInitParameter.class);
    private Map<WebEnvironmentEntry, String> envEntries = new EnumMap<WebEnvironmentEntry, String>(WebEnvironmentEntry.class);
    private Map<WebContextInitParameter, String[]> cachedListParams;
    private Set<String> setParams = new HashSet<String>();
    private ServletContext servletContext;
    private ArrayList<DeferredLoggingAction> deferredLoggingActions;
    private FaceletsConfiguration faceletsConfig;
    private boolean hasFlows;

    private WebConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
        String string = this.getServletContextName();
        this.initSetList(servletContext);
        this.processBooleanParameters(servletContext, string);
        this.processInitParameters(servletContext, string);
        if (this.canProcessJndiEntries()) {
            this.processJndiEntries(string);
        }
        this.cachedListParams = new HashMap<WebContextInitParameter, String[]>(3);
        this.getOptionValue(WebContextInitParameter.ResourceExcludes, " ");
        this.getOptionValue(WebContextInitParameter.DefaultSuffix, " ");
        this.getOptionValue(WebContextInitParameter.FaceletsViewMappings, ";");
    }

    public static WebConfiguration getInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return WebConfiguration.getInstance(facesContext.getExternalContext());
    }

    public static WebConfiguration getInstance(ExternalContext externalContext) {
        WebConfiguration webConfiguration = (WebConfiguration)externalContext.getApplicationMap().get(WEB_CONFIG_KEY);
        if (webConfiguration == null) {
            return WebConfiguration.getInstance((ServletContext)externalContext.getContext());
        }
        return webConfiguration;
    }

    public static WebConfiguration getInstance(ServletContext servletContext) {
        WebConfiguration webConfiguration = (WebConfiguration)servletContext.getAttribute(WEB_CONFIG_KEY);
        if (webConfiguration == null) {
            webConfiguration = new WebConfiguration(servletContext);
            servletContext.setAttribute(WEB_CONFIG_KEY, (Object)webConfiguration);
        }
        return webConfiguration;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isHasFlows() {
        return this.hasFlows;
    }

    public void setHasFlows(boolean bl) {
        this.hasFlows = bl;
    }

    public boolean isOptionEnabled(BooleanWebContextInitParameter booleanWebContextInitParameter) {
        if (this.booleanContextParameters.get((Object)booleanWebContextInitParameter) != null) {
            return this.booleanContextParameters.get((Object)booleanWebContextInitParameter);
        }
        return booleanWebContextInitParameter.getDefaultValue();
    }

    public String getOptionValue(WebContextInitParameter webContextInitParameter) {
        WebContextInitParameter webContextInitParameter2;
        String string = this.contextParameters.get((Object)webContextInitParameter);
        if (null == string && null != (webContextInitParameter2 = webContextInitParameter.getAlternate())) {
            string = this.contextParameters.get((Object)webContextInitParameter2);
        }
        return string;
    }

    public void setOptionValue(WebContextInitParameter webContextInitParameter, String string) {
        this.contextParameters.put(webContextInitParameter, string);
    }

    public void setOptionEnabled(BooleanWebContextInitParameter booleanWebContextInitParameter, boolean bl) {
        this.booleanContextParameters.put(booleanWebContextInitParameter, bl);
    }

    public FaceletsConfiguration getFaceletsConfiguration() {
        if (null == this.faceletsConfig) {
            this.faceletsConfig = new FaceletsConfiguration(this);
        }
        return this.faceletsConfig;
    }

    public Map<String, String> getFacesConfigOptionValue(WebContextInitParameter webContextInitParameter, boolean bl) {
        Map<String, String> map = null;
        assert (null != this.facesConfigParameters);
        map = this.facesConfigParameters.get((Object)webContextInitParameter);
        if (null == map) {
            if (bl) {
                map = new ConcurrentHashMap<String, String>(3);
                this.facesConfigParameters.put(webContextInitParameter, map);
            } else {
                map = Collections.emptyMap();
            }
        }
        return map;
    }

    public Map<String, String> getFacesConfigOptionValue(WebContextInitParameter webContextInitParameter) {
        return this.getFacesConfigOptionValue(webContextInitParameter, false);
    }

    public String[] getOptionValue(WebContextInitParameter webContextInitParameter, String string) {
        assert (null != this.cachedListParams);
        String[] stringArray = this.cachedListParams.get((Object)webContextInitParameter);
        if (null == stringArray) {
            String string2 = this.getOptionValue(webContextInitParameter);
            if (null == string2) {
                stringArray = new String[]{};
            } else {
                Map map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
                stringArray = Util.split(map, string2, string);
            }
            this.cachedListParams.put(webContextInitParameter, stringArray);
        }
        return stringArray;
    }

    public String getEnvironmentEntry(WebEnvironmentEntry webEnvironmentEntry) {
        return this.envEntries.get((Object)webEnvironmentEntry);
    }

    public boolean isSet(WebContextInitParameter webContextInitParameter) {
        return this.isSet(webContextInitParameter.getQualifiedName());
    }

    public boolean isSet(BooleanWebContextInitParameter booleanWebContextInitParameter) {
        return this.isSet(booleanWebContextInitParameter.getQualifiedName());
    }

    public String getServletContextName() {
        if (this.servletContext.getMajorVersion() == 2 && this.servletContext.getMinorVersion() <= 4) {
            return this.servletContext.getServletContextName();
        }
        return this.servletContext.getContextPath();
    }

    public void overrideContextInitParameter(BooleanWebContextInitParameter booleanWebContextInitParameter, boolean bl) {
        if (booleanWebContextInitParameter == null) {
            return;
        }
        boolean bl2 = this.booleanContextParameters.put(booleanWebContextInitParameter, bl);
        if (LOGGER.isLoggable(Level.FINE) && bl2 != bl) {
            LOGGER.log(Level.FINE, "Overriding init parameter {0}.  Changing from {1} to {2}.", new Object[]{booleanWebContextInitParameter.getQualifiedName(), bl2, bl});
        }
    }

    public void overrideContextInitParameter(WebContextInitParameter webContextInitParameter, String string) {
        if (webContextInitParameter == null || string == null || string.length() == 0) {
            return;
        }
        string = string.trim();
        String string2 = this.contextParameters.put(webContextInitParameter, string);
        this.cachedListParams.remove((Object)webContextInitParameter);
        if (string2 != null && LOGGER.isLoggable(Level.FINE) && !string2.equals(string)) {
            LOGGER.log(Level.FINE, "Overriding init parameter {0}.  Changing from {1} to {2}.", new Object[]{webContextInitParameter.getQualifiedName(), string2, string});
        }
    }

    public void doPostBringupActions() {
        boolean bl;
        if (this.deferredLoggingActions != null) {
            for (DeferredLoggingAction object : this.deferredLoggingActions) {
                object.log();
            }
        }
        if (bl = this.isOptionEnabled(BooleanWebContextInitParameter.EnableHttpMethodRestrictionPhaseListener)) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Iterator iterator = lifecycleFactory.getLifecycleIds();
            HttpMethodRestrictionsPhaseListener httpMethodRestrictionsPhaseListener = null;
            while (iterator.hasNext()) {
                Lifecycle lifecycle = lifecycleFactory.getLifecycle((String)iterator.next());
                boolean bl2 = false;
                for (PhaseListener phaseListener : lifecycle.getPhaseListeners()) {
                    if (!(phaseListener instanceof HttpMethodRestrictionsPhaseListener)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                if (null == httpMethodRestrictionsPhaseListener) {
                    httpMethodRestrictionsPhaseListener = new HttpMethodRestrictionsPhaseListener();
                }
                lifecycle.addPhaseListener(httpMethodRestrictionsPhaseListener);
            }
        }
        this.discoverResourceLibraryContracts();
    }

    private void discoverResourceLibraryContracts() {
        Object object;
        HashSet<String> hashSet;
        ExternalContext externalContext;
        block14: {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            externalContext = facesContext.getExternalContext();
            hashSet = new HashSet<String>();
            String string = this.getOptionValue(WebContextInitParameter.WebAppContractsDirectory);
            assert (null != string);
            Set set = externalContext.getResourcePaths(string);
            if (null != set) {
                int n = string.length();
                for (String string2 : set) {
                    int n2 = string2.length();
                    if (string2.endsWith("/")) {
                        --n2;
                    }
                    hashSet.add(string2.substring(n + 1, n2));
                }
            }
            try {
                object = Classpath.search(Util.getCurrentLoader(this), META_INF_CONTRACTS_DIR, RESOURCE_CONTRACT_SUFFIX, Classpath.SearchAdvice.FirstMatchOnly);
                for (Object object2 : object) {
                    int n;
                    String string3 = ((URL)object2).toExternalForm();
                    int n3 = string3.indexOf(META_INF_CONTRACTS_DIR) + META_INF_CONTRACTS_DIR_LEN + 1;
                    if (n3 >= (n = string3.indexOf(RESOURCE_CONTRACT_SUFFIX))) continue;
                    hashSet.add(string3.substring(n3, n));
                }
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block14;
                LOGGER.log(Level.FINEST, "Unable to scan " + META_INF_CONTRACTS_DIR, iOException);
            }
        }
        if (hashSet.isEmpty()) {
            return;
        }
        object = new HashMap();
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
        Map<String, List<String>> map = applicationAssociate.getResourceLibraryContracts();
        if (null != map && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                Object object2;
                object2 = (List)entry.getValue();
                if (null == object2 || object2.isEmpty()) {
                    if (!LOGGER.isLoggable(Level.CONFIG)) continue;
                    LOGGER.log(Level.CONFIG, "resource library contract mapping for pattern {0} has no contracts.", entry.getKey());
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (hashSet.contains(string)) {
                        arrayList.add(string);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.CONFIG)) continue;
                    LOGGER.log(Level.CONFIG, "resource library contract mapping for pattern {0} exposes contract {1}, but that contract is not available to the application.", new String[]{(String)entry.getKey(), string});
                }
                if (arrayList.isEmpty()) continue;
                object.put(entry.getKey(), arrayList);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(hashSet);
            object.put("*", arrayList);
        }
        externalContext.getApplicationMap().put(FaceletViewHandlingStrategy.RESOURCE_LIBRARY_CONTRACT_DATA_STRUCTURE_KEY, object);
    }

    static void clear(ServletContext servletContext) {
        servletContext.removeAttribute(WEB_CONFIG_KEY);
    }

    private boolean isValueValid(BooleanWebContextInitParameter booleanWebContextInitParameter, String string) {
        if (!ALLOWABLE_BOOLEANS.matcher(string).matches()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.config.webconfig.boolconfig.invalidvalue", new Object[]{string, booleanWebContextInitParameter.getQualifiedName(), "true|false", "true|false", booleanWebContextInitParameter.getDefaultValue()});
            }
            return false;
        }
        return true;
    }

    private void processBooleanParameters(ServletContext servletContext, String string) {
        for (BooleanWebContextInitParameter booleanWebContextInitParameter : BooleanWebContextInitParameter.values()) {
            boolean bl;
            String string2 = servletContext.getInitParameter(booleanWebContextInitParameter.getQualifiedName());
            if (string2 != null && string2.length() > 0 && booleanWebContextInitParameter.isDeprecated()) {
                BooleanWebContextInitParameter booleanWebContextInitParameter2 = booleanWebContextInitParameter.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    if (booleanWebContextInitParameter2 != null) {
                        this.queueLoggingAction(new DeferredBooleanParameterLoggingAction(booleanWebContextInitParameter, Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{string, booleanWebContextInitParameter.getQualifiedName(), booleanWebContextInitParameter2.getQualifiedName()}));
                    } else {
                        this.queueLoggingAction(new DeferredBooleanParameterLoggingAction(booleanWebContextInitParameter, Level.WARNING, "jsf.config.webconfig.param.deprecated.no_replacement", new Object[]{string, booleanWebContextInitParameter.getQualifiedName()}));
                    }
                }
                if (booleanWebContextInitParameter2 == null) continue;
                bl = this.isValueValid(booleanWebContextInitParameter, string2) ? Boolean.valueOf(string2).booleanValue() : booleanWebContextInitParameter.getDefaultValue();
                if (LOGGER.isLoggable(Level.INFO) && booleanWebContextInitParameter2 != null) {
                    this.queueLoggingAction(new DeferredBooleanParameterLoggingAction(booleanWebContextInitParameter, Level.INFO, bl ? "jsf.config.webconfig.configinfo.reset.enabled" : "jsf.config.webconfig.configinfo.reset.disabled", new Object[]{string, booleanWebContextInitParameter2.getQualifiedName()}));
                }
                this.booleanContextParameters.put(booleanWebContextInitParameter2, bl);
                continue;
            }
            if (booleanWebContextInitParameter.isDeprecated()) continue;
            bl = string2 == null ? booleanWebContextInitParameter.getDefaultValue() : (this.isValueValid(booleanWebContextInitParameter, string2) ? Boolean.valueOf(string2).booleanValue() : booleanWebContextInitParameter.getDefaultValue());
            if (BooleanWebContextInitParameter.DisplayConfiguration.equals((Object)booleanWebContextInitParameter) && bl) {
                this.loggingLevel = Level.INFO;
            }
            if (LOGGER.isLoggable(this.loggingLevel)) {
                LOGGER.log(this.loggingLevel, bl ? "jsf.config.webconfig.boolconfiginfo.enabled" : "jsf.config.webconfig.boolconfiginfo.disabled", new Object[]{string, booleanWebContextInitParameter.getQualifiedName()});
            }
            this.booleanContextParameters.put(booleanWebContextInitParameter, bl);
        }
    }

    private void initSetList(ServletContext servletContext) {
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!string.startsWith("com.sun.faces") && !string.startsWith("javax.faces")) continue;
            this.setParams.add(string);
        }
    }

    private boolean isSet(String string) {
        return this.setParams.contains(string);
    }

    private void processInitParameters(ServletContext servletContext, String string) {
        for (WebContextInitParameter webContextInitParameter : WebContextInitParameter.values()) {
            String string2 = servletContext.getInitParameter(webContextInitParameter.getQualifiedName());
            if (string2 != null && string2.length() > 0 && webContextInitParameter.isDeprecated()) {
                WebContextInitParameter webContextInitParameter2 = webContextInitParameter.getAlternate();
                DeprecationLoggingStrategy deprecationLoggingStrategy = webContextInitParameter.getDeprecationLoggingStrategy();
                if ((deprecationLoggingStrategy == null || deprecationLoggingStrategy.shouldBeLogged(this)) && LOGGER.isLoggable(Level.WARNING)) {
                    if (webContextInitParameter2 != null) {
                        this.queueLoggingAction(new DeferredParameterLoggingAction(webContextInitParameter, Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{string, webContextInitParameter.getQualifiedName(), webContextInitParameter2.getQualifiedName()}));
                    } else {
                        this.queueLoggingAction(new DeferredParameterLoggingAction(webContextInitParameter, Level.WARNING, "jsf.config.webconfig.param.deprecated.no_replacement", new Object[]{string, webContextInitParameter.getQualifiedName()}));
                    }
                }
                if (webContextInitParameter2 == null) continue;
                this.queueLoggingAction(new DeferredParameterLoggingAction(webContextInitParameter, Level.INFO, "jsf.config.webconfig.configinfo.reset", new Object[]{string, webContextInitParameter2.getQualifiedName(), string2}));
                this.contextParameters.put(webContextInitParameter2, string2);
                continue;
            }
            if (!(string2 != null && string2.length() != 0 || webContextInitParameter.isDeprecated())) {
                string2 = webContextInitParameter.getDefaultValue();
            }
            if (string2 == null || string2.length() == 0) continue;
            if (string2.length() > 0) {
                if (LOGGER.isLoggable(this.loggingLevel)) {
                    LOGGER.log(this.loggingLevel, "jsf.config.webconfig.configinfo", new Object[]{string, webContextInitParameter.getQualifiedName(), string2});
                }
                this.contextParameters.put(webContextInitParameter, string2);
                continue;
            }
            if (!LOGGER.isLoggable(this.loggingLevel)) continue;
            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.option.notconfigured", new Object[]{string, webContextInitParameter.getQualifiedName()});
        }
    }

    private void processJndiEntries(String string) {
        block19: {
            InitialContext initialContext;
            block16: {
                initialContext = null;
                try {
                    initialContext = new InitialContext();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, noClassDefFoundError.toString(), noClassDefFoundError);
                    }
                }
                catch (NamingException namingException) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block16;
                    LOGGER.log(Level.WARNING, namingException.toString(), namingException);
                }
            }
            if (initialContext != null) {
                block18: {
                    for (WebEnvironmentEntry webEnvironmentEntry : WebEnvironmentEntry.values()) {
                        String string2;
                        String string3;
                        block17: {
                            string3 = webEnvironmentEntry.getQualifiedName();
                            string2 = null;
                            try {
                                string2 = (String)initialContext.lookup(string3);
                            }
                            catch (NamingException namingException) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block17;
                                LOGGER.fine(namingException.toString());
                            }
                        }
                        if (string2 == null) continue;
                        if (LOGGER.isLoggable(Level.INFO) && LOGGER.isLoggable(this.loggingLevel)) {
                            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventryinfo", new Object[]{string, string3, string2});
                        }
                        this.envEntries.put(webEnvironmentEntry, string2);
                    }
                    try {
                        Object namingException = initialContext.lookup("java:comp/BeanManager");
                        if (null != namingException) {
                            Util.setCDIAvailable(this.servletContext, namingException);
                        }
                    }
                    catch (NamingException namingException) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block18;
                        LOGGER.fine(namingException.toString());
                    }
                }
                if (!Util.isCDIAvailable(this.servletContext)) {
                    try {
                        Object object = initialContext.lookup("java:comp/env/BeanManager");
                        if (null != object) {
                            Util.setCDIAvailable(this.servletContext, object);
                        }
                    }
                    catch (NamingException namingException) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.fine(namingException.toString());
                    }
                }
            }
        }
    }

    public boolean canProcessJndiEntries() {
        try {
            Util.getCurrentLoader(this).loadClass("javax.naming.InitialContext");
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("javax.naming is unavailable.  JNDI entries related to Mojarra configuration will not be processed.");
            }
            return false;
        }
        return true;
    }

    private void queueLoggingAction(DeferredLoggingAction deferredLoggingAction) {
        if (this.deferredLoggingActions == null) {
            this.deferredLoggingActions = new ArrayList();
        }
        this.deferredLoggingActions.add(deferredLoggingAction);
    }

    private class DeferredBooleanParameterLoggingAction
    implements DeferredLoggingAction {
        private BooleanWebContextInitParameter parameter;
        private Level loggingLevel;
        private String logKey;
        private Object[] params;

        DeferredBooleanParameterLoggingAction(BooleanWebContextInitParameter booleanWebContextInitParameter, Level level, String string, Object[] objectArray) {
            this.parameter = booleanWebContextInitParameter;
            this.loggingLevel = level;
            this.logKey = string;
            this.params = objectArray;
        }

        public void log() {
            DeprecationLoggingStrategy deprecationLoggingStrategy;
            if (LOGGER.isLoggable(this.loggingLevel) && (deprecationLoggingStrategy = this.parameter.getDeprecationLoggingStrategy()) != null && deprecationLoggingStrategy.shouldBeLogged(WebConfiguration.this)) {
                LOGGER.log(this.loggingLevel, this.logKey, this.params);
            }
        }
    }

    private class DeferredParameterLoggingAction
    implements DeferredLoggingAction {
        private WebContextInitParameter parameter;
        private Level loggingLevel;
        private String logKey;
        private Object[] params;

        DeferredParameterLoggingAction(WebContextInitParameter webContextInitParameter, Level level, String string, Object[] objectArray) {
            this.parameter = webContextInitParameter;
            this.loggingLevel = level;
            this.logKey = string;
            this.params = objectArray;
        }

        public void log() {
            DeprecationLoggingStrategy deprecationLoggingStrategy;
            if (LOGGER.isLoggable(this.loggingLevel) && (deprecationLoggingStrategy = this.parameter.getDeprecationLoggingStrategy()) != null && deprecationLoggingStrategy.shouldBeLogged(WebConfiguration.this)) {
                LOGGER.log(this.loggingLevel, this.logKey, this.params);
            }
        }
    }

    private static interface DeferredLoggingAction {
        public void log();
    }

    private static class FaceletsConfigParamLoggingStrategy
    implements DeprecationLoggingStrategy {
        private FaceletsConfigParamLoggingStrategy() {
        }

        public boolean shouldBeLogged(WebConfiguration webConfiguration) {
            return !webConfiguration.isOptionEnabled(BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        }
    }

    private static interface DeprecationLoggingStrategy {
        public boolean shouldBeLogged(WebConfiguration var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisableUnicodeEscaping {
        True("true"),
        False("false"),
        Auto("auto");

        private final String value;

        private DisableUnicodeEscaping(String string2) {
            this.value = string2;
        }

        public static DisableUnicodeEscaping getByValue(String string) {
            for (DisableUnicodeEscaping disableUnicodeEscaping : DisableUnicodeEscaping.values()) {
                if (!disableUnicodeEscaping.value.equals(string)) continue;
                return disableUnicodeEscaping;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebEnvironmentEntry {
        ProjectStage("java:comp/env/jsf/ProjectStage");

        private static final String JNDI_PREFIX = "java:comp/env/";
        private String qualifiedName;

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebEnvironmentEntry(String string2) {
            this.qualifiedName = string2.startsWith(JNDI_PREFIX) ? string2 : JNDI_PREFIX + string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanWebContextInitParameter {
        DisplayConfiguration("com.sun.faces.displayConfiguration", false),
        ValidateFacesConfigFiles("com.sun.faces.validateXml", false),
        VerifyFacesConfigObjects("com.sun.faces.verifyObjects", false),
        ForceLoadFacesConfigFiles("com.sun.faces.forceLoadConfiguration", false),
        DisableArtifactVersioning("com.sun.faces.disableVersionTracking", false, true, null),
        DisableClientStateEncryption("com.sun.faces.disableClientStateEncryption", false),
        EnableClientStateDebugging("com.sun.faces.enableClientStateDebugging", false),
        EnableHtmlTagLibraryValidator("com.sun.faces.enableHtmlTagLibValidator", false),
        EnableCoreTagLibraryValidator("com.sun.faces.enableCoreTagLibValidator", false),
        PreferXHTMLContentType("com.sun.faces.preferXHTML", false),
        PreferXHTMLContextTypeDeprecated("com.sun.faces.PreferXHTML", false, true, PreferXHTMLContentType),
        CompressViewState("com.sun.faces.compressViewState", true),
        CompressViewStateDeprecated("com.sun.faces.COMPRESS_STATE", true, true, CompressViewState),
        CompressJavaScript("com.sun.faces.compressJavaScript", true),
        ExternalizeJavaScriptDeprecated("com.sun.faces.externalizeJavaScript", true, true, null),
        SendPoweredByHeader("com.sun.faces.sendPoweredByHeader", false),
        EnableJSStyleHiding("com.sun.faces.enableJSStyleHiding", false),
        EnableScriptInAttributeValue("com.sun.faces.enableScriptsInAttributeValues", true),
        WriteStateAtFormEnd("com.sun.faces.writeStateAtFormEnd", true),
        EnableLazyBeanValidation("com.sun.faces.enableLazyBeanValidation", true),
        EnableLoadBundle11Compatibility("com.sun.faces.enabledLoadBundle11Compatibility", false),
        EnableRestoreView11Compatibility("com.sun.faces.enableRestoreView11Compatibility", false),
        SerializeServerState("javax.faces.SERIALIZE_SERVER_STATE", false),
        SerializeServerStateDeprecated("com.sun.faces.serializeServerState", false, true, SerializeServerState),
        EnableViewStateIdRendering("com.sun.faces.enableViewStateIdRendering", true),
        RegisterConverterPropertyEditors("com.sun.faces.registerConverterPropertyEditors", false),
        EnableGroovyScripting("com.sun.faces.enableGroovyScripting", false),
        DisableFaceletJSFViewHandler("DISABLE_FACELET_JSF_VIEWHANDLER", false),
        DisableDefaultBeanValidator("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR", false),
        DateTimeConverterUsesSystemTimezone("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE", false),
        EnableHttpMethodRestrictionPhaseListener("com.sun.faces.ENABLE_HTTP_METHOD_RESTRICTION_PHASE_LISTENER", false),
        FaceletsSkipComments("javax.faces.FACELETS_SKIP_COMMENTS", false),
        FaceletsSkipCommentsDeprecated("facelets.SKIP_COMMENTS", false, true, FaceletsSkipComments, new FaceletsConfigParamLoggingStrategy()),
        PartialStateSaving("javax.faces.PARTIAL_STATE_SAVING", true),
        GenerateUniqueServerStateIds("com.sun.faces.generateUniqueServerStateIds", true),
        AutoCompleteOffOnViewState("com.sun.faces.autoCompleteOffOnViewState", true),
        EnableThreading("com.sun.faces.enableThreading", false),
        AllowTextChildren("com.sun.faces.allowTextChildren", false),
        CacheResourceModificationTimestamp("com.sun.faces.cacheResourceModificationTimestamp", false),
        EnableAgressiveSessionDirtying("com.sun.faces.enableAgressiveSessionDirtying", false),
        EnableDistributable("com.sun.faces.enableDistributable", false),
        EnableMissingResourceLibraryDetection("com.sun.faces.enableMissingResourceLibraryDetection", false),
        DisableIdUniquenessCheck("com.sun.faces.disableIdUniquenessCheck", false),
        EnableTransitionTimeNoOpFlash("com.sun.faces.enableTransitionTimeNoOpFlash", false),
        NamespaceParameters("com.sun.faces.namespaceParameters", false);

        private BooleanWebContextInitParameter alternate;
        private String qualifiedName;
        private boolean defaultValue;
        private boolean deprecated;
        private DeprecationLoggingStrategy loggingStrategy;

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        DeprecationLoggingStrategy getDeprecationLoggingStrategy() {
            return this.loggingStrategy;
        }

        private BooleanWebContextInitParameter(String string2, boolean bl) {
            this(string2, bl, false, null);
        }

        private BooleanWebContextInitParameter(String string2, boolean bl, boolean bl2, BooleanWebContextInitParameter booleanWebContextInitParameter) {
            this.qualifiedName = string2;
            this.defaultValue = bl;
            this.deprecated = bl2;
            this.alternate = booleanWebContextInitParameter;
        }

        private BooleanWebContextInitParameter(String string2, boolean bl, boolean bl2, BooleanWebContextInitParameter booleanWebContextInitParameter, DeprecationLoggingStrategy deprecationLoggingStrategy) {
            this(string2, bl, bl2, booleanWebContextInitParameter);
            this.loggingStrategy = deprecationLoggingStrategy;
        }

        private BooleanWebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebContextInitParameter {
        ManagedBeanFactoryDecorator("com.sun.faces.managedBeanFactoryDecoratorClass", ""),
        StateSavingMethod("javax.faces.STATE_SAVING_METHOD", "server"),
        FaceletsSuffix("javax.faces.FACELETS_SUFFIX", ".xhtml"),
        DefaultSuffix("javax.faces.DEFAULT_SUFFIX", ".xhtml .view.xml .jsp"),
        JavaxFacesConfigFiles("javax.faces.CONFIG_FILES", ""),
        JavaxFacesProjectStage("javax.faces.PROJECT_STAGE", "Production"),
        AlternateLifecycleId("javax.faces.LIFECYCLE_ID", ""),
        ResourceExcludes("javax.faces.RESOURCE_EXCLUDES", ".class .jsp .jspx .properties .xhtml .groovy .groovy"),
        NumberOfViews("com.sun.faces.numberOfViewsInSession", "15"),
        NumberOfViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION", "15", true, NumberOfViews),
        NumberOfLogicalViews("com.sun.faces.numberOfLogicalViews", "15"),
        NumberOfLogicalViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION", "15", true, NumberOfLogicalViews),
        NumberOfConcurrentFlashUsers("com.sun.faces.numberOfConcerrentFlashUsers", "5000"),
        NumberOfFlashesBetweenFlashReapings("com.sun.faces.numberOfFlashesBetweenFlashReapings", "5000"),
        InjectionProviderClass("com.sun.faces.injectionProvider", ""),
        SerializationProviderClass("com.sun.faces.serializationProvider", ""),
        ResponseBufferSize("com.sun.faces.responseBufferSize", "1024"),
        FaceletsBufferSize("javax.faces.FACELETS_BUFFER_SIZE", "1024"),
        FaceletsBufferSizeDeprecated("facelets.BUFFER_SIZE", "1024", true, FaceletsBufferSize, new FaceletsConfigParamLoggingStrategy()),
        ClientStateWriteBufferSize("com.sun.faces.clientStateWriteBufferSize", "8192"),
        ResourceBufferSize("com.sun.faces.resourceBufferSize", "2048"),
        ExpressionFactory("com.sun.faces.expressionFactory", "com.sun.el.ExpressionFactoryImpl"),
        ClientStateTimeout("com.sun.faces.clientStateTimeout", ""),
        DefaultResourceMaxAge("com.sun.faces.defaultResourceMaxAge", "604800000"),
        ResourceUpdateCheckPeriod("com.sun.faces.resourceUpdateCheckPeriod", "5"),
        CompressableMimeTypes("com.sun.faces.compressableMimeTypes", ""),
        DisableUnicodeEscaping("com.sun.faces.disableUnicodeEscaping", "auto"),
        FaceletsDefaultRefreshPeriod("javax.faces.FACELETS_REFRESH_PERIOD", "2"),
        FaceletsDefaultRefreshPeriodDeprecated("facelets.REFRESH_PERIOD", "2", true, FaceletsDefaultRefreshPeriod, new FaceletsConfigParamLoggingStrategy()),
        FaceletsResourceResolver("javax.faces.FACELETS_RESOURCE_RESOLVER", ""),
        FaceletsResourceResolverDeprecated("facelets.RESOURCE_RESOLVER", "", true, FaceletsResourceResolver, new FaceletsConfigParamLoggingStrategy()),
        FaceletsViewMappings("javax.faces.FACELETS_VIEW_MAPPINGS", ""),
        FaceletsViewMappingsDeprecated("facelets.VIEW_MAPPINGS", "", true, FaceletsViewMappings, new FaceletsConfigParamLoggingStrategy()),
        FaceletsLibraries("javax.faces.FACELETS_LIBRARIES", ""),
        FaceletsLibrariesDeprecated("facelets.LIBRARIES", "", true, FaceletsLibraries, new FaceletsConfigParamLoggingStrategy()),
        FaceletsDecorators("javax.faces.FACELETS_DECORATORS", ""),
        FaceletsDecoratorsDeprecated("facelets.DECORATORS", "", true, FaceletsDecorators, new FaceletsConfigParamLoggingStrategy()),
        DuplicateJARPattern("com.sun.faces.duplicateJARPattern", ""),
        ValidateEmptyFields("javax.faces.VALIDATE_EMPTY_FIELDS", "auto"),
        FullStateSavingViewIds("javax.faces.FULL_STATE_SAVING_VIEW_IDS", ""),
        AnnotationScanPackages("com.sun.faces.annotationScanPackages", ""),
        FaceletCache("com.sun.faces.faceletCache", ""),
        FaceletsProcessingFileExtensionProcessAs("", ""),
        ClientWindowMode("javax.faces.CLIENT_WINDOW_MODE", "none"),
        WebAppResourcesDirectory("javax.faces.WEBAPP_RESOURCES_DIRECTORY", "/resources"),
        WebAppContractsDirectory("javax.faces.WEBAPP_CONTRACTS_DIRECTORY", "/contracts");

        private String defaultValue;
        private String qualifiedName;
        private WebContextInitParameter alternate;
        private boolean deprecated;
        private DeprecationLoggingStrategy loggingStrategy;

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        DeprecationLoggingStrategy getDeprecationLoggingStrategy() {
            return this.loggingStrategy;
        }

        private WebContextInitParameter(String string2, String string3) {
            this(string2, string3, false, null);
        }

        private WebContextInitParameter(String string2, String string3, boolean bl, WebContextInitParameter webContextInitParameter) {
            this.qualifiedName = string2;
            this.defaultValue = string3;
            this.deprecated = bl;
            this.alternate = webContextInitParameter;
        }

        private WebContextInitParameter(String string2, String string3, boolean bl, WebContextInitParameter webContextInitParameter, DeprecationLoggingStrategy deprecationLoggingStrategy) {
            this(string2, string3, bl, webContextInitParameter);
            this.loggingStrategy = deprecationLoggingStrategy;
        }

        private WebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

