/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppFlowConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Logger logger = FacesLogger.CONFIG.getLogger();

    @Override
    public Collection<URI> getResources(ServletContext servletContext) {
        List<URI> list = Collections.emptyList();
        Set set = servletContext.getResourcePaths("/");
        if (null == set) {
            return list;
        }
        list = null;
        for (String string : set) {
            if (string.startsWith("/META-INF")) continue;
            if (string.equals("/WEB-INF/")) {
                Set set2 = servletContext.getResourcePaths(string);
                if (null == set2) continue;
                for (String string2 : set2) {
                    if (string.equals("/WEB-INF/classes/") || !string2.endsWith("/")) continue;
                    list = this.inspectDirectory(servletContext, string2, list);
                }
                continue;
            }
            if (!string.endsWith("/")) continue;
            list = this.inspectDirectory(servletContext, string, list);
        }
        return null == list ? Collections.EMPTY_LIST : list;
    }

    private List<URI> inspectDirectory(ServletContext servletContext, String string, List<URI> list) {
        URL uRL = null;
        Set set = servletContext.getResourcePaths(string);
        if (null == set) {
            return list;
        }
        for (String string2 : set) {
            if (!string2.endsWith("-flow.xml")) continue;
            if (null == list) {
                list = new ArrayList<URI>();
            }
            try {
                uRL = servletContext.getResource(string2);
                list.add(uRL.toURI());
            }
            catch (MalformedURLException malformedURLException) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, "Unable to get resource for {0}" + string2, malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, "Unable to get URI for {0}" + uRL.toExternalForm(), uRISyntaxException);
            }
        }
        return list;
    }
}

