/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProtectedViewsConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String PROTECTED_VIEWS = "protected-views";
    private static final String URL_PATTERN = "url-pattern";

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing protected-views element for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, PROTECTED_VIEWS);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.processProtectedViews(nodeList, string, documentInfoArray[i]);
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void processProtectedViews(NodeList nodeList, String string, DocumentInfo documentInfo) {
        WebConfiguration webConfiguration = null;
        ViewHandler viewHandler = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                String string2 = null;
                if (URL_PATTERN.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, MessageFormat.format("Processing protected-views elements for document: ''{0}'', encountered unexpected configuration ''{1}'', ignoring and continuing", documentInfo.getSourceURI(), this.getNodeText(node2)));
                }
                if (null != string2) {
                    if (null == webConfiguration) {
                        webConfiguration = WebConfiguration.getInstance();
                    }
                    if (null == viewHandler) {
                        FacesContext facesContext = FacesContext.getCurrentInstance();
                        viewHandler = facesContext.getApplication().getViewHandler();
                    }
                    viewHandler.addProtectedView(string2);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, MessageFormat.format("Processing protected-views elements for document: ''{0}'', encountered <url-pattern> element without expected children", documentInfo.getSourceURI()));
            }
        }
    }
}

