/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.component.visit.PartialVisitContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitContextWrapper;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialViewContextImpl
extends PartialViewContext {
    private static Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private PartialResponseWriter partialResponseWriter;
    private List<String> executeIds;
    private Collection<String> renderIds;
    private Boolean ajaxRequest;
    private Boolean partialRequest;
    private Boolean renderAll;
    private FacesContext ctx;
    private boolean processingPhases = false;
    private static final String ORIGINAL_WRITER = "com.sun.faces.ORIGINAL_WRITER";

    public PartialViewContextImpl(FacesContext facesContext) {
        this.ctx = facesContext;
    }

    public boolean isAjaxRequest() {
        this.assertNotReleased();
        if (this.ajaxRequest == null) {
            this.ajaxRequest = "partial/ajax".equals(this.ctx.getExternalContext().getRequestHeaderMap().get("Faces-Request"));
            if (!this.ajaxRequest.booleanValue()) {
                this.ajaxRequest = "partial/ajax".equals(this.ctx.getExternalContext().getRequestParameterMap().get("Faces-Request"));
            }
        }
        return this.ajaxRequest;
    }

    public boolean isPartialRequest() {
        this.assertNotReleased();
        if (this.partialRequest == null) {
            this.partialRequest = this.isAjaxRequest() || "partial/process".equals(this.ctx.getExternalContext().getRequestHeaderMap().get("Faces-Request"));
        }
        return this.partialRequest;
    }

    public boolean isExecuteAll() {
        this.assertNotReleased();
        String string = (String)this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute");
        return "@all".equals(string);
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this.renderAll == null) {
            String string = (String)this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render");
            this.renderAll = "@all".equals(string);
        }
        return this.renderAll;
    }

    public void setRenderAll(boolean bl) {
        this.renderAll = bl;
    }

    public boolean isResetValues() {
        Object v = this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.resetValues");
        return null != v && "true".equals(v);
    }

    public void setPartialRequest(boolean bl) {
        this.partialRequest = bl;
    }

    public Collection<String> getExecuteIds() {
        UIViewRoot uIViewRoot;
        this.assertNotReleased();
        if (this.executeIds != null) {
            return this.executeIds;
        }
        this.executeIds = this.populatePhaseClientIds("javax.faces.partial.execute");
        if (!this.executeIds.isEmpty() && (uIViewRoot = this.ctx.getViewRoot()).getFacetCount() > 0 && uIViewRoot.getFacet("javax_faces_metadata") != null) {
            this.executeIds.add(0, "javax_faces_metadata");
        }
        return this.executeIds;
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.renderIds != null) {
            return this.renderIds;
        }
        this.renderIds = this.populatePhaseClientIds("javax.faces.partial.render");
        return this.renderIds;
    }

    public void processPartial(PhaseId phaseId) {
        PartialViewContext partialViewContext = this.ctx.getPartialViewContext();
        Collection collection = partialViewContext.getExecuteIds();
        Collection collection2 = partialViewContext.getRenderIds();
        UIViewRoot uIViewRoot = this.ctx.getViewRoot();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            if (collection == null || collection.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "No execute and render identifiers specified.  Skipping component processing.");
                }
                return;
            }
            try {
                this.processComponents((UIComponent)uIViewRoot, phaseId, collection, this.ctx);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, exception.toString(), exception);
                }
                throw new FacesException((Throwable)exception);
            }
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                PartialResponseWriter partialResponseWriter = partialViewContext.getPartialResponseWriter();
                this.ctx.setResponseWriter((ResponseWriter)partialResponseWriter);
            }
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            try {
                PartialResponseWriter partialResponseWriter = partialViewContext.getPartialResponseWriter();
                ResponseWriter responseWriter = this.ctx.getResponseWriter();
                this.ctx.getAttributes().put(ORIGINAL_WRITER, responseWriter);
                this.ctx.setResponseWriter((ResponseWriter)partialResponseWriter);
                ExternalContext externalContext = this.ctx.getExternalContext();
                externalContext.setResponseContentType("text/xml");
                externalContext.addResponseHeader("Cache-Control", "no-cache");
                partialResponseWriter.startDocument();
                if (this.isResetValues()) {
                    uIViewRoot.resetValues(this.ctx, collection2);
                }
                if (this.isRenderAll()) {
                    this.renderAll(this.ctx, uIViewRoot);
                    this.renderState(this.ctx);
                    partialResponseWriter.endDocument();
                    return;
                }
                if (collection2 != null && !collection2.isEmpty()) {
                    this.processComponents((UIComponent)uIViewRoot, phaseId, collection2, this.ctx);
                }
                this.renderState(this.ctx);
                partialResponseWriter.endDocument();
            }
            catch (IOException iOException) {
                this.cleanupAfterView();
            }
            catch (RuntimeException runtimeException) {
                this.cleanupAfterView();
                throw runtimeException;
            }
        }
    }

    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this.partialResponseWriter == null) {
            this.partialResponseWriter = new DelayedInitPartialResponseWriter(this);
        }
        return this.partialResponseWriter;
    }

    public void release() {
        this.released = true;
        this.ajaxRequest = null;
        this.renderAll = null;
        this.partialResponseWriter = null;
        this.executeIds = null;
        this.renderIds = null;
        this.ctx = null;
        this.partialRequest = null;
    }

    private List<String> populatePhaseClientIds(String string) {
        Map map = this.ctx.getExternalContext().getRequestParameterMap();
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return new ArrayList<String>();
        }
        Map map2 = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        String[] stringArray = Util.split(map2, string2, "[ \t]+");
        return stringArray != null && stringArray.length != 0 ? new ArrayList<String>(Arrays.asList(stringArray)) : new ArrayList<String>();
    }

    private void processComponents(UIComponent uIComponent, PhaseId phaseId, Collection<String> collection, FacesContext facesContext) throws IOException {
        EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_UNRENDERED, VisitHint.EXECUTE_LIFECYCLE);
        VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
        VisitContext visitContext = visitContextFactory.getVisitContext(facesContext, collection, enumSet);
        PhaseAwareVisitCallback phaseAwareVisitCallback = new PhaseAwareVisitCallback(this.ctx, phaseId);
        uIComponent.visitTree(visitContext, (VisitCallback)phaseAwareVisitCallback);
        PartialVisitContext partialVisitContext = PartialViewContextImpl.unwrapPartialVisitContext(visitContext);
        if (partialVisitContext != null && LOGGER.isLoggable(Level.FINER) && !partialVisitContext.getUnvisitedClientIds().isEmpty()) {
            Collection<String> collection2 = partialVisitContext.getUnvisitedClientIds();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : collection2) {
                stringBuilder.append(string).append(" ");
            }
            LOGGER.log(Level.FINER, "jsf.context.partial_visit_context_unvisited_children", new Object[]{stringBuilder.toString()});
        }
    }

    private static PartialVisitContext unwrapPartialVisitContext(VisitContext visitContext) {
        if (visitContext == null) {
            return null;
        }
        if (visitContext instanceof PartialVisitContext) {
            return (PartialVisitContext)visitContext;
        }
        if (visitContext instanceof VisitContextWrapper) {
            return PartialViewContextImpl.unwrapPartialVisitContext(((VisitContextWrapper)visitContext).getWrapped());
        }
        return null;
    }

    private void renderAll(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException {
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        PartialResponseWriter partialResponseWriter = partialViewContext.getPartialResponseWriter();
        if (!Util.isPortletRequest(facesContext)) {
            partialResponseWriter.startUpdate("javax.faces.ViewRoot");
            if (uIViewRoot.getChildCount() > 0) {
                for (UIComponent uIComponent : uIViewRoot.getChildren()) {
                    uIComponent.encodeAll(facesContext);
                }
            }
            partialResponseWriter.endUpdate();
        } else {
            partialResponseWriter.startUpdate(uIViewRoot.getClientId(this.ctx));
            uIViewRoot.encodeBegin(facesContext);
            if (uIViewRoot.getChildCount() > 0) {
                for (UIComponent uIComponent : uIViewRoot.getChildren()) {
                    uIComponent.encodeAll(facesContext);
                }
            }
            uIViewRoot.encodeEnd(facesContext);
            partialResponseWriter.endUpdate();
        }
    }

    private void renderState(FacesContext facesContext) throws IOException {
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        PartialResponseWriter partialResponseWriter = partialViewContext.getPartialResponseWriter();
        String string = Util.getViewStateId(facesContext);
        partialResponseWriter.startUpdate(string);
        String string2 = facesContext.getApplication().getStateManager().getViewState(facesContext);
        partialResponseWriter.write(string2);
        partialResponseWriter.endUpdate();
        ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
        if (null != clientWindow) {
            String string3 = Util.getClientWindowId(facesContext);
            partialResponseWriter.startUpdate(string3);
            partialResponseWriter.write(clientWindow.getId());
            partialResponseWriter.endUpdate();
        }
    }

    private PartialResponseWriter createPartialResponseWriter() {
        Writer writer;
        ResponseWriter responseWriter;
        String string;
        block6: {
            ExternalContext externalContext = this.ctx.getExternalContext();
            string = externalContext.getRequestCharacterEncoding();
            externalContext.setResponseCharacterEncoding(string);
            responseWriter = null;
            writer = null;
            try {
                writer = externalContext.getResponseOutputWriter();
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
        if (writer != null) {
            UIViewRoot uIViewRoot = this.ctx.getViewRoot();
            if (uIViewRoot != null) {
                responseWriter = this.ctx.getRenderKit().createResponseWriter(writer, "text/xml", string);
            } else {
                RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderKitFactory.getRenderKit(this.ctx, "HTML_BASIC");
                responseWriter = renderKit.createResponseWriter(writer, "text/xml", string);
            }
        }
        if (responseWriter instanceof PartialResponseWriter) {
            return (PartialResponseWriter)responseWriter;
        }
        return new PartialResponseWriter(responseWriter);
    }

    private void cleanupAfterView() {
        ResponseWriter responseWriter = (ResponseWriter)this.ctx.getAttributes().get(ORIGINAL_WRITER);
        assert (null != responseWriter);
        this.ctx.setResponseWriter(responseWriter);
    }

    private final void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private static final class DelayedInitPartialResponseWriter
    extends PartialResponseWriter {
        private ResponseWriter writer;
        private PartialViewContextImpl ctx;

        public DelayedInitPartialResponseWriter(PartialViewContextImpl partialViewContextImpl) {
            super(null);
            this.ctx = partialViewContextImpl;
            ExternalContext externalContext = partialViewContextImpl.ctx.getExternalContext();
            externalContext.setResponseContentType("text/xml");
            externalContext.setResponseCharacterEncoding(externalContext.getRequestCharacterEncoding());
        }

        public ResponseWriter getWrapped() {
            if (this.writer == null) {
                this.writer = this.ctx.createPartialResponseWriter();
            }
            return this.writer;
        }
    }

    private static class PhaseAwareVisitCallback
    implements VisitCallback {
        private PhaseId curPhase;
        private FacesContext ctx;

        private PhaseAwareVisitCallback(FacesContext facesContext, PhaseId phaseId) {
            this.ctx = facesContext;
            this.curPhase = phaseId;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
            block8: {
                try {
                    if (this.curPhase == PhaseId.APPLY_REQUEST_VALUES) {
                        uIComponent.processDecodes(this.ctx);
                        break block8;
                    }
                    if (this.curPhase == PhaseId.PROCESS_VALIDATIONS) {
                        uIComponent.processValidators(this.ctx);
                        break block8;
                    }
                    if (this.curPhase == PhaseId.UPDATE_MODEL_VALUES) {
                        uIComponent.processUpdates(this.ctx);
                        break block8;
                    }
                    if (this.curPhase == PhaseId.RENDER_RESPONSE) {
                        PartialResponseWriter partialResponseWriter = this.ctx.getPartialViewContext().getPartialResponseWriter();
                        partialResponseWriter.startUpdate(uIComponent.getClientId(this.ctx));
                        uIComponent.encodeAll(this.ctx);
                        partialResponseWriter.endUpdate();
                        break block8;
                    }
                    throw new IllegalStateException("I18N: Unexpected PhaseId passed to  PhaseAwareContextCallback: " + this.curPhase.toString());
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(iOException.toString());
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, iOException.toString(), iOException);
                    }
                    throw new FacesException((Throwable)iOException);
                }
            }
            return VisitResult.REJECT;
        }
    }
}

