/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.util.Cache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private Compiler compiler;
    private ResourceResolver resolver;
    private URL baseUrl;
    private long refreshPeriod;
    private FaceletCache<DefaultFacelet> cache;
    private ConcurrentMap<String, FaceletCache<DefaultFacelet>> cachePerContract;
    Cache<String, IdMapper> idMappers;

    public DefaultFaceletFactory() {
        this.compiler = null;
        this.resolver = null;
        this.refreshPeriod = -1L;
        this.cache = null;
        this.baseUrl = null;
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resourceResolver) throws IOException {
        this(compiler, resourceResolver, -1L, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resourceResolver, long l) {
        this(compiler, resourceResolver, l, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resourceResolver, long l, FaceletCache faceletCache) {
        this.init(compiler, resourceResolver, l, faceletCache);
    }

    public final void init(Compiler compiler, ResourceResolver resourceResolver, long l, FaceletCache faceletCache) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resourceResolver);
        this.compiler = compiler;
        this.cachePerContract = new ConcurrentHashMap<String, FaceletCache<DefaultFacelet>>();
        this.resolver = resourceResolver;
        this.baseUrl = resourceResolver.resolveUrl("/");
        this.idMappers = new Cache<String, IdMapper>(new IdMapperFactory());
        this.refreshPeriod = l = l >= 0L ? l * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using ResourceResolver: {0}", resourceResolver);
            log.log(Level.FINE, "Using Refresh Period: {0}", l);
        }
        this.cache = this.initCache((FaceletCache<DefaultFacelet>)faceletCache);
    }

    private FaceletCache<DefaultFacelet> initCache(FaceletCache<DefaultFacelet> faceletCache) {
        Object object;
        if (faceletCache == null) {
            object = (FaceletCacheFactory)FactoryFinder.getFactory((String)"javax.faces.view.facelets.FaceletCacheFactory");
            faceletCache = object.getFaceletCache();
        }
        object = new FaceletCache.MemberFactory<DefaultFacelet>(){

            public DefaultFacelet newInstance(URL uRL) throws IOException {
                return DefaultFaceletFactory.this.createFacelet(uRL);
            }
        };
        FaceletCache.MemberFactory<DefaultFacelet> memberFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            public DefaultFacelet newInstance(URL uRL) throws IOException {
                return DefaultFaceletFactory.this.createMetadataFacelet(uRL);
            }
        };
        try {
            Method method = FaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
            method.setAccessible(true);
            method.invoke((Object)faceletCache, object, memberFactory);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, null, exception);
            }
            throw new FacesException((Throwable)exception);
        }
        return faceletCache;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getFacelet(FacesContext facesContext, String string) throws IOException {
        return this.getFacelet(facesContext, this.resolveURL(string));
    }

    public Facelet getMetadataFacelet(FacesContext facesContext, String string) throws IOException {
        return this.getMetadataFacelet(facesContext, this.resolveURL(string));
    }

    public URL resolveURL(URL uRL, String string) throws IOException {
        if (string.startsWith("/")) {
            URL uRL2 = this.resolver.resolveUrl(string);
            if (uRL2 == null) {
                throw new FacesFileNotFoundException(string + " Not Found in ExternalContext as a Resource");
            }
            return uRL2;
        }
        return new URL(uRL, string);
    }

    public Facelet getFacelet(FacesContext facesContext, URL uRL) throws IOException {
        Facelet facelet = (Facelet)this.getCache(facesContext).getFacelet(uRL);
        DefaultFacelet defaultFacelet = null;
        if (facelet instanceof DefaultFacelet) {
            String string;
            defaultFacelet = (DefaultFacelet)facelet;
            String string2 = defaultFacelet.getSavedDoctype();
            if (null != string2) {
                Util.saveDOCTYPEToFacesContextAttributes(string2);
            }
            if (null != (string = defaultFacelet.getSavedXMLDecl())) {
                Util.saveXMLDECLToFacesContextAttributes(string);
            }
        }
        return facelet;
    }

    public Facelet getMetadataFacelet(FacesContext facesContext, URL uRL) throws IOException {
        return (Facelet)this.getCache(facesContext).getViewMetadataFacelet(uRL);
    }

    public boolean needsToBeRefreshed(URL uRL) {
        if (!this.cache.isFaceletCached(uRL)) {
            return true;
        }
        if (this.cachePerContract == null) {
            return false;
        }
        for (FaceletCache faceletCache : this.cachePerContract.values()) {
            if (faceletCache.isFaceletCached(uRL)) continue;
            return true;
        }
        return false;
    }

    private FaceletCache<DefaultFacelet> getCache(FacesContext facesContext) {
        List list = facesContext.getResourceLibraryContracts();
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append((String)list.get(i));
                if (i + 1 == list.size()) continue;
                stringBuilder.append(",");
            }
            String string = stringBuilder.toString();
            FaceletCache faceletCache = (FaceletCache)this.cachePerContract.get(string);
            if (faceletCache == null) {
                faceletCache = this.initCache(null);
                this.cachePerContract.putIfAbsent(string, faceletCache);
                faceletCache = (FaceletCache)this.cachePerContract.get(string);
            }
            return faceletCache;
        }
        return this.cache;
    }

    private URL resolveURL(String string) throws IOException {
        URL uRL = this.resolveURL(this.baseUrl, string);
        if (uRL == null) {
            throw new IOException("'" + string + "' not found.");
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent _createComponent(FacesContext facesContext, String string, String string2, Map<String, Object> map) {
        UIComponent uIComponent;
        block29: {
            uIComponent = null;
            Application application = facesContext.getApplication();
            ExternalContext externalContext = facesContext.getExternalContext();
            File file = (File)externalContext.getApplicationMap().get("javax.servlet.context.tempdir");
            File file2 = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                String string3;
                block26: {
                    file2 = File.createTempFile("mojarra", ".tmp", file);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
                    outputStreamWriter.append("<?xml version='1.0' encoding='");
                    outputStreamWriter.append("UTF-8");
                    outputStreamWriter.append("' ?>");
                    outputStreamWriter.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
                    outputStreamWriter.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"\n");
                    outputStreamWriter.append("      xmlns:j=\"").append(string).append("\">");
                    outputStreamWriter.append("  <j:").append(string2).append(" ");
                    if (null != map && !map.isEmpty()) {
                        for (Map.Entry object2 : map.entrySet()) {
                            outputStreamWriter.append((CharSequence)object2.getKey()).append("=\"").append(object2.getValue().toString()).append("\"").append(" ");
                        }
                    }
                    string3 = facesContext.getViewRoot().createUniqueId(facesContext, string2);
                    outputStreamWriter.append(" id=\"").append(string3).append("\" />");
                    outputStreamWriter.append("</html>");
                    try {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        if (!log.isLoggable(Level.FINEST)) break block26;
                        log.log(Level.FINEST, "Flushing and closing stream", iOException);
                    }
                }
                URL uRL = file2.toURI().toURL();
                DefaultFacelet defaultFacelet = this.createFacelet(uRL);
                UIComponent uIComponent2 = application.createComponent("javax.faces.NamingContainer");
                uIComponent2.setId(facesContext.getViewRoot().createUniqueId());
                defaultFacelet.apply(facesContext, uIComponent2);
                uIComponent = uIComponent2.findComponent(string3);
                uIComponent2.getChildren().clear();
                outputStreamWriter = null;
            }
            catch (MalformedURLException malformedURLException) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Invalid URL", malformedURLException);
                }
            }
            catch (IOException iOException) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "I/O error", iOException);
                }
            }
            finally {
                boolean bl;
                block28: {
                    if (null != outputStreamWriter) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException) {
                            if (!log.isLoggable(Level.FINEST)) break block28;
                            log.log(Level.FINEST, "Closing stream", iOException);
                        }
                    }
                }
                if (null != file2 && !(bl = file2.delete()) && log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Unable to delete temporary file.");
                }
            }
            try {
                byte[] byArray = "facelet".getBytes("UTF-8");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!log.isLoggable(Level.SEVERE)) break block29;
                log.log(Level.SEVERE, "Unsupported encoding when creating component for " + string2 + " in " + string, unsupportedEncodingException);
            }
        }
        if (null != uIComponent) {
            uIComponent.setId(null);
        }
        return uIComponent;
    }

    private DefaultFacelet createFacelet(URL uRL) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + uRL);
        }
        String string = Pattern.quote(this.baseUrl.getFile());
        String string2 = '/' + uRL.getFile().replaceFirst(string, "");
        try {
            FaceletHandler faceletHandler = this.compiler.compile(uRL, string2);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), uRL, string2, faceletHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Facelet " + string2 + " not found at: " + uRL.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL uRL) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Metadata Facelet for: " + uRL);
        }
        String string = Pattern.quote(this.baseUrl.getFile());
        String string2 = '/' + uRL.getFile().replaceFirst(string, "");
        try {
            FaceletHandler faceletHandler = this.compiler.metadataCompile(uRL, string2);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), uRL, string2, faceletHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Facelet " + string2 + " not found at: " + uRL.toExternalForm());
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdMapperFactory
    implements Cache.Factory<String, IdMapper> {
        private IdMapperFactory() {
        }

        @Override
        public IdMapper newInstance(String string) throws InterruptedException {
            return new IdMapper();
        }
    }
}

