/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.el.LegacyValueBinding;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public class SetPropertyActionListenerHandler
extends TagHandlerImpl
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute value = this.getRequiredAttribute("value");
    private final TagAttribute target = this.getRequiredAttribute("target");

    public SetPropertyActionListenerHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        if (null == uIComponent || !ComponentHandler.isNew((UIComponent)uIComponent)) {
            return;
        }
        if (uIComponent instanceof ActionSource) {
            this.applyAttachedObject(faceletContext.getFacesContext(), uIComponent);
        } else if (UIComponent.isCompositeComponent((UIComponent)uIComponent)) {
            if (null == this.getFor()) {
                throw new TagException(this.tag, "actionListener tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(uIComponent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + uIComponent);
        }
    }

    public void applyAttachedObject(FacesContext facesContext, UIComponent uIComponent) {
        FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
        ActionSource actionSource = (ActionSource)uIComponent;
        ValueExpression valueExpression = this.value.getValueExpression(faceletContext, Object.class);
        ValueExpression valueExpression2 = this.target.getValueExpression(faceletContext, Object.class);
        ActionListener actionListener = actionSource instanceof ActionSource2 ? new SetPropertyListener(valueExpression, valueExpression2) : new LegacySetPropertyListener(new LegacyValueBinding(valueExpression), new LegacyValueBinding(valueExpression2));
        actionSource.addActionListener(actionListener);
    }

    public String getFor() {
        String string = null;
        TagAttribute tagAttribute = this.getAttribute("for");
        if (null != tagAttribute) {
            if (tagAttribute.isLiteral()) {
                string = tagAttribute.getValue();
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
                string = (String)tagAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            }
        }
        return string;
    }

    private static class SetPropertyListener
    implements ActionListener,
    Serializable {
        private ValueExpression value;
        private ValueExpression target;

        public SetPropertyListener() {
        }

        public SetPropertyListener(ValueExpression valueExpression, ValueExpression valueExpression2) {
            this.value = valueExpression;
            this.target = valueExpression2;
        }

        public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext eLContext = facesContext.getELContext();
            Object object = this.value.getValue(eLContext);
            if (object != null) {
                ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                object = expressionFactory.coerceToType(object, this.target.getType(eLContext));
            }
            this.target.setValue(eLContext, object);
        }
    }

    private static class LegacySetPropertyListener
    implements ActionListener,
    Serializable {
        private ValueBinding value;
        private ValueBinding target;

        public LegacySetPropertyListener() {
        }

        public LegacySetPropertyListener(ValueBinding valueBinding, ValueBinding valueBinding2) {
            this.value = valueBinding;
            this.target = valueBinding2;
        }

        public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Object object = this.value.getValue(facesContext);
            this.target.setValue(facesContext, object);
        }
    }
}

