/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.streaming;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.streaming.XMLReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public abstract class XMLStreamReaderFactory {
    @NotNull
    private static volatile XMLStreamReaderFactory theInstance;

    public static void set(XMLStreamReaderFactory f) {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        theInstance = f;
    }

    public static XMLStreamReaderFactory get() {
        return theInstance;
    }

    public static XMLStreamReader create(InputSource source, boolean rejectDTDs) {
        try {
            if (source.getCharacterStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(source.getSystemId(), source.getCharacterStream(), rejectDTDs);
            }
            if (source.getByteStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(source.getSystemId(), source.getByteStream(), rejectDTDs);
            }
            return XMLStreamReaderFactory.get().doCreate(source.getSystemId(), new URL(source.getSystemId()).openStream(), rejectDTDs);
        }
        catch (IOException e) {
            throw new XMLReaderException("stax.cantCreate", e);
        }
    }

    public static XMLStreamReader create(@Nullable String systemId, InputStream in, boolean rejectDTDs) {
        return XMLStreamReaderFactory.get().doCreate(systemId, in, rejectDTDs);
    }

    public static XMLStreamReader create(@Nullable String systemId, Reader reader, boolean rejectDTDs) {
        return XMLStreamReaderFactory.get().doCreate(systemId, reader, rejectDTDs);
    }

    public static void recycle(XMLStreamReader r) {
        XMLStreamReaderFactory.get().doRecycle(r);
    }

    public abstract XMLStreamReader doCreate(String var1, InputStream var2, boolean var3);

    public abstract XMLStreamReader doCreate(String var1, Reader var2, boolean var3);

    public abstract void doRecycle(XMLStreamReader var1);

    static {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isNamespaceAware", true);
        XMLStreamReaderFactory f = null;
        if (!Boolean.getBoolean(XMLStreamReaderFactory.class.getName() + ".noPool")) {
            f = Zephyr.newInstance(xif);
        }
        if (f == null && xif.getClass().getName().equals("com.ctc.wstx.stax.WstxInputFactory")) {
            f = new Woodstox(xif);
        }
        if (f == null) {
            f = new Default(xif);
        }
        theInstance = f;
    }

    public static final class Woodstox
    extends NoLock {
        public Woodstox(XMLInputFactory xif) {
            super(xif);
            xif.setProperty("org.codehaus.stax2.internNsUris", true);
        }

        public XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }

        public XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }
    }

    public static class NoLock
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;

        public NoLock(XMLInputFactory xif) {
            this.xif = xif;
        }

        public XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            try {
                return this.xif.createXMLStreamReader(systemId, in);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
        }

        public XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            try {
                return this.xif.createXMLStreamReader(systemId, in);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
        }

        public void doRecycle(XMLStreamReader r) {
        }
    }

    public static final class Default
    extends NoLock {
        public Default(XMLInputFactory xif) {
            super(xif);
        }

        public synchronized XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }

        public synchronized XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }
    }

    public static final class Zephyr
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;
        private final ThreadLocal<XMLStreamReader> pool = new ThreadLocal();
        private final Method setInputSourceMethod;
        private final Method resetMethod;
        private final Class zephyrClass;

        @Nullable
        public static XMLStreamReaderFactory newInstance(XMLInputFactory xif) {
            try {
                Class<?> clazz = xif.createXMLStreamReader(new StringReader("<foo/>")).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.stream.")) {
                    return null;
                }
                return new Zephyr(xif, clazz);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (XMLStreamException e) {
                return null;
            }
        }

        public Zephyr(XMLInputFactory xif, Class clazz) throws NoSuchMethodException {
            this.zephyrClass = clazz;
            this.setInputSourceMethod = clazz.getMethod("setInputSource", InputSource.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
            try {
                xif.setProperty("reuse-instance", false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.xif = xif;
        }

        @Nullable
        private XMLStreamReader fetch() {
            XMLStreamReader sr = this.pool.get();
            if (sr == null) {
                return null;
            }
            this.pool.set(null);
            return sr;
        }

        public void doRecycle(XMLStreamReader r) {
            if (this.zephyrClass.isInstance(r)) {
                this.pool.set(r);
            }
            if (r instanceof RecycleAware) {
                ((RecycleAware)((Object)r)).onRecycled();
            }
        }

        public XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            try {
                XMLStreamReader xsr = this.fetch();
                if (xsr == null) {
                    return this.xif.createXMLStreamReader(systemId, in);
                }
                InputSource is = new InputSource(systemId);
                is.setByteStream(in);
                this.reuse(xsr, is);
                return xsr;
            }
            catch (IllegalAccessException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
            catch (InvocationTargetException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
        }

        public XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            try {
                XMLStreamReader xsr = this.fetch();
                if (xsr == null) {
                    return this.xif.createXMLStreamReader(systemId, in);
                }
                InputSource is = new InputSource(systemId);
                is.setCharacterStream(in);
                this.reuse(xsr, is);
                return xsr;
            }
            catch (IllegalAccessException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
            catch (InvocationTargetException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", e);
            }
        }

        private void reuse(XMLStreamReader xsr, InputSource in) throws IllegalAccessException, InvocationTargetException {
            this.resetMethod.invoke((Object)xsr, new Object[0]);
            this.setInputSourceMethod.invoke((Object)xsr, in);
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }
}

