/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

final class YCbCrUpsamplerStream
extends FilterInputStream {
    static final double[] CCIR_601_1_COEFFICIENTS = new double[]{0.299, 0.587, 0.114};
    private final int horizChromaSub;
    private final int vertChromaSub;
    private final int yCbCrPos;
    private final int columns;
    private final double[] coefficients;
    private final int units;
    private final int unitSize;
    private final int padding;
    private final byte[] decodedRows;
    int decodedLength;
    int decodedPos;
    private final byte[] buffer;
    int bufferLength;
    int bufferPos;

    public YCbCrUpsamplerStream(InputStream inputStream, int[] nArray, int n, int n2, double[] dArray) {
        super((InputStream)Validate.notNull((Object)inputStream, (String)"stream"));
        Validate.notNull((Object)nArray, (String)"chromaSub");
        Validate.isTrue((nArray.length == 2 ? 1 : 0) != 0, (String)"chromaSub.length != 2");
        this.horizChromaSub = nArray[0];
        this.vertChromaSub = nArray[1];
        this.yCbCrPos = n;
        this.columns = n2;
        this.coefficients = Arrays.equals(CCIR_601_1_COEFFICIENTS, dArray) ? null : dArray;
        this.unitSize = this.horizChromaSub * this.vertChromaSub + 2;
        this.units = (n2 + this.horizChromaSub - 1) / this.horizChromaSub;
        this.padding = this.units * this.horizChromaSub - n2;
        this.decodedRows = new byte[n2 * this.vertChromaSub * 3];
        this.buffer = new byte[this.unitSize * this.units];
    }

    private void fetch() throws IOException {
        if (this.bufferPos >= this.bufferLength) {
            int n;
            int n2;
            for (n = 0; n < this.buffer.length && (n2 = this.in.read(this.buffer, n, this.buffer.length - n)) > 0; n += n2) {
            }
            this.bufferLength = n;
            this.bufferPos = 0;
        }
        if (this.bufferLength > 0) {
            this.decodeRows();
        } else {
            this.decodedLength = -1;
        }
    }

    private void decodeRows() throws EOFException {
        this.decodedLength = this.decodedRows.length;
        for (int i = 0; i < this.units; ++i) {
            if (this.bufferPos >= this.bufferLength) {
                throw new EOFException("Unexpected end of stream");
            }
            byte by = this.buffer[this.bufferPos + this.unitSize - 2];
            byte by2 = this.buffer[this.bufferPos + this.unitSize - 1];
            block1: for (int j = 0; j < this.vertChromaSub; ++j) {
                for (int k = 0; k < this.horizChromaSub; ++k) {
                    int n = this.horizChromaSub * i + k;
                    if (n >= this.columns) {
                        this.bufferPos += this.padding;
                        continue block1;
                    }
                    int n2 = 3 * (n + this.columns * j);
                    this.decodedRows[n2] = this.buffer[this.bufferPos++];
                    this.decodedRows[n2 + 1] = by;
                    this.decodedRows[n2 + 2] = by2;
                    if (this.coefficients == null) {
                        YCbCrConverter.convertYCbCr2RGB(this.decodedRows, this.decodedRows, n2);
                        continue;
                    }
                    this.convertYCbCr2RGB(this.decodedRows, this.decodedRows, this.coefficients, n2);
                }
            }
            this.bufferPos += 2;
        }
        this.bufferPos = this.bufferLength;
        this.decodedPos = 0;
    }

    public int read() throws IOException {
        if (this.decodedLength < 0) {
            return -1;
        }
        if (this.decodedPos >= this.decodedLength) {
            this.fetch();
            if (this.decodedLength < 0) {
                return -1;
            }
        }
        return this.decodedRows[this.decodedPos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.decodedLength < 0) {
            return -1;
        }
        if (this.decodedPos >= this.decodedLength) {
            this.fetch();
            if (this.decodedLength < 0) {
                return -1;
            }
        }
        int n3 = Math.min(this.decodedLength - this.decodedPos, n2);
        System.arraycopy(this.decodedRows, this.decodedPos, byArray, n, n3);
        this.decodedPos += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.decodedLength < 0) {
            return -1L;
        }
        if (this.decodedPos >= this.decodedLength) {
            this.fetch();
            if (this.decodedLength < 0) {
                return -1L;
            }
        }
        int n = (int)Math.min((long)(this.decodedLength - this.decodedPos), l);
        this.decodedPos += n;
        return n;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    private void convertYCbCr2RGB(byte[] byArray, byte[] byArray2, double[] dArray, int n) {
        double d = byArray[n] & 0xFF;
        double d2 = (byArray[n + 1] & 0xFF) - 128;
        double d3 = (byArray[n + 2] & 0xFF) - 128;
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        int n2 = (int)Math.round(d3 * (2.0 - 2.0 * d4) + d);
        int n3 = (int)Math.round(d2 * (2.0 - 2.0 * d6) + d);
        int n4 = (int)Math.round((d - d4 * (double)n2 - d6 * (double)n3) / d5);
        byArray2[n] = YCbCrUpsamplerStream.clamp(n2);
        byArray2[n + 2] = YCbCrUpsamplerStream.clamp(n3);
        byArray2[n + 1] = YCbCrUpsamplerStream.clamp(n4);
    }

    private static byte clamp(int n) {
        return (byte)Math.max(0, Math.min(255, n));
    }

    static final class YCbCrConverter {
        private static final int SCALEBITS = 16;
        private static final int MAXJSAMPLE = 255;
        private static final int CENTERJSAMPLE = 128;
        private static final int ONE_HALF = 32768;
        private static final int[] Cr_R_LUT = new int[256];
        private static final int[] Cb_B_LUT = new int[256];
        private static final int[] Cr_G_LUT = new int[256];
        private static final int[] Cb_G_LUT = new int[256];

        YCbCrConverter() {
        }

        private static void buildYCCtoRGBtable() {
            if (TIFFImageReader.DEBUG) {
                System.err.println("Building YCC conversion table");
            }
            int n = 0;
            int n2 = -128;
            while (n <= 255) {
                YCbCrConverter.Cr_R_LUT[n] = (int)(91881.972 * (double)n2 + 32768.0) >> 16;
                YCbCrConverter.Cb_B_LUT[n] = (int)(116130.292 * (double)n2 + 32768.0) >> 16;
                YCbCrConverter.Cr_G_LUT[n] = -46802 * n2;
                YCbCrConverter.Cb_G_LUT[n] = -22554 * n2 + 32768;
                ++n;
                ++n2;
            }
        }

        static void convertYCbCr2RGB(Raster raster) {
            int n = raster.getHeight();
            int n2 = raster.getWidth();
            byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    YCbCrConverter.convertYCbCr2RGB(byArray, byArray, (j + i * n2) * 3);
                }
            }
        }

        static void convertYCbCr2RGB(byte[] byArray, byte[] byArray2, int n) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray[n + 2] & 0xFF;
            int n4 = byArray[n + 1] & 0xFF;
            byArray2[n] = YCbCrUpsamplerStream.clamp(n2 + YCbCrConverter.Cr_R_LUT[n3]);
            byArray2[n + 1] = YCbCrUpsamplerStream.clamp(n2 + (YCbCrConverter.Cb_G_LUT[n4] + YCbCrConverter.Cr_G_LUT[n3] >> 16));
            byArray2[n + 2] = YCbCrUpsamplerStream.clamp(n2 + YCbCrConverter.Cb_B_LUT[n4]);
        }

        static void convertYCCK2CMYK(Raster raster) {
            int n = raster.getHeight();
            int n2 = raster.getWidth();
            byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    YCbCrConverter.convertYCCK2CMYK(byArray, byArray, (j + i * n2) * 4);
                }
            }
        }

        private static void convertYCCK2CMYK(byte[] byArray, byte[] byArray2, int n) {
            int n2 = 255 - byArray[n] & 0xFF;
            int n3 = 255 - byArray[n + 1] & 0xFF;
            int n4 = 255 - byArray[n + 2] & 0xFF;
            int n5 = 255 - byArray[n + 3] & 0xFF;
            int n6 = 255 - (n2 + Cr_R_LUT[n4]);
            int n7 = 255 - (n2 + (Cb_G_LUT[n3] + Cr_G_LUT[n4] >> 16));
            int n8 = 255 - (n2 + Cb_B_LUT[n3]);
            byArray2[n] = YCbCrUpsamplerStream.clamp(n6);
            byArray2[n + 1] = YCbCrUpsamplerStream.clamp(n7);
            byArray2[n + 2] = YCbCrUpsamplerStream.clamp(n8);
            byArray2[n + 3] = (byte)n5;
        }

        static {
            YCbCrConverter.buildYCCtoRGBtable();
        }
    }
}

