/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.FastIntBuffer;
import com.ximpleware.extended.FastLongBuffer;
import java.util.ArrayList;

public class ContextBuffer {
    private ArrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int incSize;
    private int n;
    private int r;

    public ContextBuffer(int i) {
        this.pageSize = 1024;
        this.n = 10;
        this.r = this.pageSize - 1;
        this.incSize = i;
        if (this.incSize < 0) {
            throw new IllegalArgumentException();
        }
        this.bufferArrayList = new ArrayList();
    }

    public ContextBuffer(int p, int i) {
        if (p < 0) {
            throw new IllegalArgumentException("invalid Buffer size");
        }
        this.pageSize = 1 << p;
        this.r = this.pageSize - 1;
        this.n = p;
        this.incSize = i;
        if (this.incSize < 0) {
            throw new IllegalArgumentException("context buffer's incremental size must be greater than zero");
        }
        this.bufferArrayList = new ArrayList();
    }

    public boolean load(int[] output) {
        if (this.size < this.incSize) {
            return false;
        }
        int startingOffset = this.size - this.incSize;
        int len = this.incSize;
        int first_index = startingOffset >> this.n;
        int last_index = startingOffset + len >> this.n;
        if ((startingOffset + len & this.r) == 0) {
            --last_index;
        }
        if (first_index == last_index) {
            System.arraycopy((int[])this.bufferArrayList.get(first_index), startingOffset & this.r, output, 0, len);
        } else {
            int int_array_offset = 0;
            for (int i = first_index; i <= last_index; ++i) {
                int[] currentChunk = (int[])this.bufferArrayList.get(i);
                if (i == first_index) {
                    System.arraycopy(currentChunk, startingOffset & this.r, output, 0, this.pageSize - (startingOffset & this.r));
                    int_array_offset += this.pageSize - (startingOffset & this.r);
                    continue;
                }
                if (i == last_index) {
                    System.arraycopy(currentChunk, 0, output, int_array_offset, len - int_array_offset);
                    continue;
                }
                System.arraycopy(currentChunk, 0, output, int_array_offset, this.pageSize);
                int_array_offset += this.pageSize;
            }
        }
        this.size -= this.incSize;
        return true;
    }

    public static void main(String[] args) {
        try {
            int j;
            int i;
            int[] ia = new int[18];
            ContextBuffer cb = new ContextBuffer(18);
            for (i = 0; i < 57; ++i) {
                for (j = 0; j < 17; ++j) {
                    ia[j] = i;
                }
                ia[17] = -1;
                cb.store(ia);
            }
            for (i = 56; i >= 0; --i) {
                cb.load(ia);
                System.out.println("" + ia[0]);
                if (ia[17] != -1) {
                    System.out.println("store error " + i + " " + 17 + " " + ia[17]);
                }
                for (j = 16; j >= 0; --j) {
                    if (ia[j] == i) continue;
                    System.out.println(" store error " + i + " " + j + " " + ia[j]);
                }
            }
            System.out.println("cb.clear()");
            cb.clear();
            for (i = 0; i < 157; ++i) {
                for (j = 0; j < 18; ++j) {
                    ia[j] = i;
                }
                cb.store(ia);
            }
            for (i = 156; i >= 0; --i) {
                cb.load(ia);
                System.out.println("" + ia[0]);
                for (j = 17; j >= 0; --j) {
                    if (ia[j] == i) continue;
                    System.out.println(" store error " + i + " " + j + " " + ia[j]);
                }
            }
            cb.clear();
            for (i = 0; i < 257; ++i) {
                for (j = 0; j < 18; ++j) {
                    ia[j] = i;
                }
                cb.store(ia);
            }
            for (i = 256; i >= 0; --i) {
                cb.load(ia);
                System.out.println("" + ia[0]);
                for (j = 17; j >= 0; --j) {
                    if (ia[j] == i) continue;
                    System.out.println(" store error " + i + " " + j + " " + ia[j]);
                }
            }
            System.out.println("success");
            System.out.println("test fastIntBuffer");
            ia = new int[1000000];
            for (int k = 0; k < 1000000; ++k) {
                ia[k] = k;
            }
            FastIntBuffer fib = new FastIntBuffer(13);
            fib.append(ia);
            fib.clear();
            fib.append(ia);
            int[] ib = fib.toIntArray();
            for (int i2 = 0; i2 < 1000000; ++i2) {
                if (ib[i2] == i2) continue;
                System.out.println("error occurred at " + i2);
            }
            System.out.println("test fastLongBuffer");
            long[] la = new long[1000000];
            for (int k = 0; k < 1000000; ++k) {
                la[k] = k;
            }
            FastLongBuffer flb = new FastLongBuffer(14);
            flb.append(la);
            flb.clear();
            flb.append(la);
            long[] lb = flb.toLongArray();
            for (int i3 = 0; i3 < 1000000; ++i3) {
                if (lb[i3] == (long)i3) continue;
                System.out.println("error occurred at " + i3);
            }
            System.out.println("success");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" exception caught ");
        }
    }

    public void clear() {
        this.size = 0;
    }

    public void store(int[] input) {
        int lastBufferIndex;
        int[] lastBuffer;
        if (input == null) {
            throw new IllegalArgumentException("context buffer can't store a null pointer");
        }
        if (this.bufferArrayList.size() == 0) {
            lastBuffer = new int[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            lastBufferIndex = 0;
            this.capacity = this.pageSize;
        } else {
            lastBufferIndex = Math.min(this.size >> this.n, this.bufferArrayList.size() - 1);
            lastBuffer = (int[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size + input.length < this.capacity) {
            if (this.size + input.length < lastBufferIndex + 1 << this.n) {
                System.arraycopy(input, 0, lastBuffer, this.size & this.r, input.length);
            } else {
                int z;
                int offset = this.pageSize - (this.size & this.r);
                System.arraycopy(input, 0, lastBuffer, this.size & this.r, offset);
                int l = input.length - offset;
                int k = l >> this.n;
                for (z = 1; z <= k; ++z) {
                    System.arraycopy(input, offset, (int[])this.bufferArrayList.get(lastBufferIndex + z), 0, this.pageSize);
                    offset += this.pageSize;
                }
                System.arraycopy(input, offset, (int[])this.bufferArrayList.get(lastBufferIndex + z), 0, l & this.r);
            }
            this.size += input.length;
            return;
        }
        int k = (input.length + this.size >> this.n) + ((input.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.n);
        System.arraycopy(input, 0, lastBuffer, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < k; ++i) {
            int[] newBuffer = new int[this.pageSize];
            if (i < k - 1) {
                System.arraycopy(input, this.pageSize * i + this.capacity - this.size, newBuffer, 0, this.pageSize);
            } else {
                System.arraycopy(input, this.pageSize * i + this.capacity - this.size, newBuffer, 0, input.length + this.size - this.pageSize * i - this.capacity);
            }
            this.bufferArrayList.add(newBuffer);
        }
        this.size += input.length;
        this.capacity += k << this.n;
    }
}

