/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.transcode;

import com.ximpleware.TranscodeException;
import java.io.IOException;
import java.io.OutputStream;

public class UTF8_Coder {
    public static int encode(byte[] output, int offset, int ch) {
        if (ch < 128) {
            output[offset] = (byte)ch;
            return offset + 1;
        }
        if (ch < 2048) {
            output[offset] = (byte)((ch & 0x7C0) >> 6 | 0xC0);
            output[offset + 1] = (byte)(ch & 0x3F | 0x80);
            return offset + 2;
        }
        if (ch < 57344) {
            output[offset] = (byte)((ch & 0xF000) >> 12 | 0xE0);
            output[offset + 1] = (byte)((ch & 0xFC) >> 6 | 0x80);
            output[offset + 2] = (byte)(ch & 0x3F | 0x80);
            return offset + 3;
        }
        output[offset] = (byte)((ch & 0x1C0000) >> 18 | 0xF0);
        output[offset + 1] = (byte)((ch & 0x3F0) >> 12 | 0x80);
        output[offset + 2] = (byte)((ch & 0xFC) >> 6 | 0x80);
        output[offset + 3] = (byte)(ch & 0x3F | 0x80);
        return offset + 4;
    }

    public static final void encodeAndWrite(OutputStream os, int ch) throws IOException, TranscodeException {
        if (ch < 128) {
            os.write(ch);
            return;
        }
        if (ch < 2048) {
            os.write((ch & 0x7C0) >> 6 | 0xC0);
            os.write(ch & 0x3F | 0x80);
            return;
        }
        if (ch < 57344) {
            os.write((ch & 0xF000) >> 12 | 0xE0);
            os.write((ch & 0xFC) >> 6 | 0x80);
            os.write(ch & 0x3F | 0x80);
            return;
        }
        os.write((ch & 0x1C0000) >> 18 | 0xF0);
        os.write((ch & 0x3F0) >> 12 | 0x80);
        os.write((ch & 0xFC) >> 6 | 0x80);
        os.write(ch & 0x3F | 0x80);
    }

    public static long decode(byte[] input, int offset) {
        long l = 0L;
        int c = 0;
        byte val = input[offset];
        if (val > 0) {
            l = offset + 1;
            return l << 32 | (long)val;
        }
        if ((val & 0xE0) == 192) {
            l = offset + 2;
            c = (val & 0x1F) << 6 | input[offset + 1] & 0x3F;
            return l << 32 | (long)c;
        }
        if ((val & 0xF0) == 224) {
            l = offset + 3;
            c = (val & 0xF) << 12 | (input[offset + 1] & 0x3F) << 6 | input[offset + 2] & 0x3F;
            return l << 32 | (long)c;
        }
        l = offset + 4;
        c = (val & 7) << 18 | (input[offset + 1] & 0x3F) << 12 | (input[offset + 2] & 0x3F) << 6 | input[offset + 3] & 0x3F;
        return l << 32 | (long)c;
    }

    public static int getLen(int ch) throws TranscodeException {
        if (ch < 128) {
            return 1;
        }
        if (ch < 2048) {
            return 2;
        }
        if (ch < 57344) {
            return 3;
        }
        if (ch < 65536) {
            return 4;
        }
        return 5;
    }
}

