/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int o, Expr e) {
        this.op = o;
        this.operand = e;
    }

    @Override
    public final String toString() {
        return "-" + this.operand;
    }

    @Override
    public final boolean evalBoolean(VTDNav vn) {
        return this.operand.evalBoolean(vn);
    }

    @Override
    public final double evalNumber(VTDNav vn) {
        return -1.0 * this.operand.evalNumber(vn);
    }

    @Override
    public final int evalNodeSet(VTDNav vn) throws XPathEvalException {
        throw new XPathEvalException("UnaryExpr can't eval to a node set!");
    }

    @Override
    public final String evalString(VTDNav vn) {
        double dval = this.operand.evalNumber(vn);
        if (dval == (double)((int)dval)) {
            return "" + (int)dval;
        }
        return "" + dval;
    }

    @Override
    public final void reset(VTDNav vn) {
        this.operand.reset(vn);
    }

    @Override
    public final boolean isNodeSet() {
        return false;
    }

    @Override
    public final boolean isNumerical() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isBoolean() {
        return false;
    }

    @Override
    public final boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    @Override
    public final void setContextSize(int size) {
        this.operand.setContextSize(size);
    }

    @Override
    public final void setPosition(int pos) {
        this.operand.setPosition(pos);
    }

    @Override
    public final int adjust(int n) {
        return 0;
    }

    @Override
    public final boolean isFinal() {
        return this.operand.isFinal();
    }

    @Override
    public final void markCacheable() {
        this.operand.markCacheable();
    }

    @Override
    public final void markCacheable2() {
        this.operand.markCacheable2();
    }

    @Override
    public final void clearCache() {
        this.operand.clearCache();
    }
}

