/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class NetUtil {
    public static final int DEFAULT_TCP_BACKLOG_WINDOWS = 200;
    public static final int DEFAULT_TCP_BACKLOG_LINUX = 128;
    public static final String TCP_BACKLOG_SETTING_LOCATION = "/proc/sys/net/core/somaxconn";

    public static int getTcpBacklog() {
        return NetUtil.getTcpBacklog(NetUtil.getDefaultTcpBacklog());
    }

    public static int getTcpBacklog(final int tcpBacklog) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    String setting = Files.toString((File)new File(NetUtil.TCP_BACKLOG_SETTING_LOCATION), (Charset)Charsets.UTF_8);
                    return Integer.parseInt(setting.trim());
                }
                catch (IOException | NullPointerException | NumberFormatException | SecurityException e) {
                    return tcpBacklog;
                }
            }
        });
    }

    public static boolean isWindows() {
        boolean windows = System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
        return windows;
    }

    public static int getDefaultTcpBacklog() {
        return NetUtil.isWindows() ? 200 : 128;
    }
}

