/*
 * Copyright 2011-2021 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.core.check.stream

import java.io.InputStream

import io.gatling.commons.validation._
import io.gatling.core.check.{ CheckBuilder, FindExtractor }
import io.gatling.core.session._

sealed trait BodyStreamCheckType

object BodyStreamCheckBuilder
    extends CheckBuilder.Find.Default[BodyStreamCheckType, () => InputStream, InputStream](
      extractor = new FindExtractor[() => InputStream, InputStream]("bodyStream", isSource => Some(isSource()).success).expressionSuccess,
      displayActualValue = false
    )
