/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.RequestExpressionBuilder$;
import io.gatling.http.request.builder.package$;
import io.gatling.http.request.builder.package$HttpParams$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005x!B\f\u0019\u0011\u0003\u0019c!B\u0013\u0019\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%I\u0001\r\u0005\u0007!\u0006\u0001\u000b\u0011B\u0019\t\u000ba\u000bA\u0011B-\u0007\u000b\u0015B\u0002!!\u0005\t\u0015\u0005eaA!A!\u0002\u0013\tY\u0002\u0003\u0006\u0002\"\u0019\u0011\t\u0011)A\u0005\u0003GA!\"!\u000b\u0007\u0005\u0003\u0005\u000b\u0011BA\u0016\u0011)\t9D\u0002B\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0003\u000b2!\u0011!Q\u0001\n\u0005\u001d\u0003BB\u0017\u0007\t\u0003\t\u0019\u0006C\u0004\u0002b\u0019!I!a\u0019\t\u000f\u0005]d\u0001\"\u0003\u0002z!I\u00111\u0012\u0004C\u0002\u0013%\u0011Q\u0012\u0005\t\u0003;3\u0001\u0015!\u0003\u0002\u0010\"I\u0011q\u0014\u0004C\u0002\u0013%\u0011Q\u0012\u0005\t\u0003C3\u0001\u0015!\u0003\u0002\u0010\"9\u00111\u0015\u0004\u0005R\u0005\u0015\u0006bBAX\r\u0011E\u0013Q\u0012\u0005\b\u0003c3A\u0011BAZ\u0011\u001d\t\tM\u0002C!\u0003\u0007\fA\u0004\u0013;uaJ+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\u001a5\u00059!-^5mI\u0016\u0014(BA\u000e\u001d\u0003\u001d\u0011X-];fgRT!!\b\u0010\u0002\t!$H\u000f\u001d\u0006\u0003?\u0001\nqaZ1uY&twMC\u0001\"\u0003\tIwn\u0001\u0001\u0011\u0005\u0011\nQ\"\u0001\r\u00039!#H\u000f\u001d*fcV,7\u000f^#yaJ,7o]5p]\n+\u0018\u000e\u001c3feN\u0011\u0011a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0013!\u00072pIf\u0004\u0016M\u001d;t)>lU\u000f\u001c;ja\u0006\u0014Ho\u001d.fe>,\u0012!\r\t\u0004e]JT\"A\u001a\u000b\u0005Q*\u0014A\u0003<bY&$\u0017\r^5p]*\u0011aGH\u0001\bG>lWn\u001c8t\u0013\tA4G\u0001\u0006WC2LG-\u0019;j_:\u00042AO B\u001b\u0005Y$B\u0001\u001f>\u0003%IW.\\;uC\ndWM\u0003\u0002?S\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001[$\u0001\u0002'jgR\u0004$A\u0011(\u0011\u0007\rSE*D\u0001E\u0015\t)e)A\u0005nk2$\u0018\u000e]1si*\u0011q\tS\u0001\u0005E>$\u0017P\u0003\u0002J9\u000511\r\\5f]RL!a\u0013#\u0003\tA\u000b'\u000f\u001e\t\u0003\u001b:c\u0001\u0001B\u0005P\t\u0005\u0005\t\u0011!B\u0001#\n\u0019q\fJ\u0019\u00025\t|G-\u001f)beR\u001cHk\\'vYRL\u0007/\u0019:ugj+'o\u001c\u0011\u0012\u0005I+\u0006C\u0001\u0015T\u0013\t!\u0016FA\u0004O_RD\u0017N\\4\u0011\u0005!2\u0016BA,*\u0005\r\te._\u0001\u0016E>$\u0017\u0010U1siN$v.T;mi&\u0004\u0018M\u001d;t)\rQ6N\u001d\t\u0004e]Z\u0006c\u0001/eM:\u0011QL\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003A\n\na\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0005\rL\u0013a\u00029bG.\fw-Z\u0005\u0003\u0001\u0016T!aY\u00151\u0005\u001dL\u0007cA\"KQB\u0011Q*\u001b\u0003\nU\u0016\t\t\u0011!A\u0003\u0002E\u00131a\u0018\u00133\u0011\u0015aW\u00011\u0001n\u0003%\u0011w\u000eZ=QCJ$8\u000fE\u0002]I:\u0004\"a\u001c9\u000e\u0003iI!!\u001d\u000e\u0003\u0011\t{G-\u001f)beRDQa]\u0003A\u0002Q\fqa]3tg&|g\u000e\u0005\u0002vs6\taO\u0003\u0002to*\u0011\u0001PH\u0001\u0005G>\u0014X-\u0003\u0002{m\n91+Z:tS>t\u0007FB\u0003}\u0003\u0013\tY\u0001E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001\u00027b]\u001eT!!a\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000fq(\u0001E*vaB\u0014Xm]:XCJt\u0017N\\4t\u0003\u00151\u0018\r\\;fY\t\ti!\t\u0002\u0002\u0010\u0005\u0001sN]4/o\u0006\u0014HO]3n_Z,'OL<beR\u001ch\u0006T5ti\u0006\u0003\b/\u001a8e'\r1\u00111\u0003\t\u0004I\u0005U\u0011bAA\f1\tA\"+Z9vKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002!\r|W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\bc\u0001\u0013\u0002\u001e%\u0019\u0011q\u0004\r\u0003!\r{W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\u0018A\u00045uiB\fE\u000f\u001e:jEV$Xm\u001d\t\u0004I\u0005\u0015\u0012bAA\u00141\tq\u0001\n\u001e;q\u0003R$(/\u001b2vi\u0016\u001c\u0018A\u00035uiB\u001c\u0015m\u00195fgB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022q\tQaY1dQ\u0016LA!!\u000e\u00020\tQ\u0001\n\u001e;q\u0007\u0006\u001c\u0007.Z:\u0002\u0019!$H\u000f\u001d)s_R|7m\u001c7\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010\u001d\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\"\u0003{\u0011A\u0002\u0013;uaB\u0013x\u000e^8d_2\fQbY8oM&<WO]1uS>t\u0007\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055s/\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003#\nYE\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u000b\r\u0003+\n9&!\u0017\u0002\\\u0005u\u0013q\f\t\u0003I\u0019Aq!!\u0007\r\u0001\u0004\tY\u0002C\u0004\u0002\"1\u0001\r!a\t\t\u000f\u0005%B\u00021\u0001\u0002,!9\u0011q\u0007\u0007A\u0002\u0005e\u0002bBA#\u0019\u0001\u0007\u0011qI\u0001\u0013G>tg-[4ve\u0016\u0014u\u000eZ=QCJ$8\u000f\u0006\u0005\u0002f\u0005=\u0014\u0011OA;!\u0011\u0011t'a\u001a\u0011\t\u0005%\u00141N\u0007\u0002\u0011&\u0019\u0011Q\u000e%\u0003\u001dI+\u0017/^3ti\n+\u0018\u000e\u001c3fe\")1/\u0004a\u0001i\"9\u00111O\u0007A\u0002\u0005\u001d\u0014A\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\u0005\u0006Y6\u0001\r!\\\u0001\bg\u0016$(i\u001c3z)!\t)'a\u001f\u0002~\u0005}\u0004\"B:\u000f\u0001\u0004!\bbBA:\u001d\u0001\u0007\u0011q\r\u0005\u0007\u000f:\u0001\r!!!\u0011\t\u0005\r\u0015qQ\u0007\u0003\u0003\u000bS!aR<\n\t\u0005%\u0015Q\u0011\u0002\u0005\u0005>$\u00170A\u0007d_:4\u0017nZ;sK\n{G-_\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u0018:\u0019A%a%\n\u0007\u0005U\u0005$\u0001\rSKF,Xm\u001d;FqB\u0014Xm]:j_:\u0014U/\u001b7eKJLA!!'\u0002\u001c\n9\"+Z9vKN$()^5mI\u0016\u00148i\u001c8gS\u001e,(/\u001a\u0006\u0004\u0003+C\u0012AD2p]\u001aLw-\u001e:f\u0005>$\u0017\u0010I\u0001\u0018G>tg-[4ve\u0016\u0004&/[8s\u0017:|w\u000f\\3eO\u0016\f\u0001dY8oM&<WO]3Qe&|'o\u00138po2,GmZ3!\u0003]\u0019wN\u001c4jOV\u0014XMU3rk\u0016\u001cH\u000fV5nK>,H\u000f\u0006\u0003\u0002(\u00065\u0006c\u0001\u0015\u0002*&\u0019\u00111V\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003g\u001a\u0002\u0019AA4\u0003\t\u001awN\u001c4jOV\u0014XMU3rk\u0016\u001cHOQ;jY\u0012,'OR8s!J|Go\\2pY\u000692m\u001c8gS\u001e,(/Z\"bG\"Lgn\u001a%fC\u0012,'o\u001d\u000b\u0005\u0003k\u000by\f\u0006\u0003\u00028\u0006u\u0006\u0003BA5\u0003sK1!a/I\u0005\u001d\u0011V-];fgRDaaG\u000bA\u0002\u0005]\u0006\"B:\u0016\u0001\u0004!\u0018!\u00022vS2$WCAAc!\u0019\t9-a7\u00028:!\u0011\u0011ZAm\u001d\u0011\tY-a6\u000f\t\u00055\u0017Q\u001b\b\u0005\u0003\u001f\f\u0019ND\u0002_\u0003#L\u0011!I\u0005\u0003?\u0001J!\u0001\u001f\u0010\n\u0005M<\u0018BA2w\u0013\u0011\ti.a8\u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0002dm\u0002")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge;

    private Validation<RequestBuilder> configureBodyParts(Session session, RequestBuilder requestBuilder, List<BodyPart> bodyParts) {
        return package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams(this.httpAttributes.formParams()), this.httpAttributes.form(), session).flatMap((Function1 & Serializable)params -> {
            Buffer stringParts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().map((Function1 & Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null));
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts(bodyParts, session).map((Function1 & Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)stringParts.$plus$plus((IterableOnce)parts)).asJava())));
        });
    }

    private Validation<RequestBuilder> setBody(Session session, RequestBuilder requestBuilder, Body body) {
        Validation validation;
        Body body2 = body;
        if (body2 instanceof StringBody) {
            StringBody stringBody = (StringBody)body2;
            Function1 string = stringBody.string();
            validation = ((Validation)string.apply((Object)session)).map((Function1 & Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else if (body2 instanceof RawFileBody) {
            RawFileBody rawFileBody = (RawFileBody)body2;
            Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
            validation = ((Validation)resourceWithCachedBytes.apply((Object)session)).map((Function1 & Serializable)x0$1 -> {
                FileRequestBodyBuilder fileRequestBodyBuilder;
                ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                if (resourceAndCachedBytes != null) {
                    Resource resource = resourceAndCachedBytes.resource();
                    Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                    Option option = cachedBytes;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        fileRequestBodyBuilder = new ByteArrayRequestBodyBuilder(bytes, resource.name());
                    } else {
                        fileRequestBodyBuilder = new FileRequestBodyBuilder(resource.file());
                    }
                } else {
                    throw new MatchError((Object)resourceAndCachedBytes);
                }
                FileRequestBodyBuilder requestBodyBuilder = fileRequestBodyBuilder;
                RequestBuilder requestBuilder = requestBuilder.setBodyBuilder((RequestBodyBuilder)requestBodyBuilder);
                return requestBuilder;
            });
        } else if (body2 instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
            Function1 bytes = byteArrayBody.bytes();
            validation = ((Validation)bytes.apply((Object)session)).map((Function1 & Serializable)b -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(b, null)));
        } else if (body2 instanceof ElBody) {
            ElBody elBody = (ElBody)body2;
            validation = ((Validation)elBody.asStringWithCachedBytes().apply((Object)session)).map((Function1 & Serializable)chunks -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringChunksRequestBodyBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)chunks).asJava())));
        } else if (body2 instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)body2;
            Function1 is2 = inputStreamBody.is();
            validation = ((Validation)is2.apply((Object)session)).map((Function1 & Serializable)is -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new InputStreamRequestBodyBuilder(is)));
        } else {
            throw new MatchError((Object)body2);
        }
        return validation;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody() {
        return this.configureBody;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge() {
        return this.configurePriorKnowledge;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(((FiniteDuration)this.httpAttributes.requestTimeout().getOrElse((Function0 & Serializable)() -> $this.configuration.http().requestTimeout())).toMillis());
    }

    @Override
    public Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureRequestBuilderForProtocol() {
        return (Function1 & Serializable)session -> (Function1 & Serializable)requestBuilder -> ((Validation)((Function1)this.configureBody().apply(session)).apply(requestBuilder)).flatMap((Function1)this.configurePriorKnowledge().apply(session));
    }

    private Request configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Function1<Session, Validation<Request>> build() {
        void var1_1;
        Function1<Session, Validation<Request>> exp = super.build();
        return this.httpProtocol.requestPart().cache() ? session -> ((Validation)exp.apply(session)).map((Function1 & Serializable)request -> this.configureCachingHeaders((Session)session, (Request)request)) : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$3(boolean x$2) {
        return x$2;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry == null) {
            throw new MatchError((Object)contentCacheEntry);
        }
        Option<String> etag = contentCacheEntry.etag();
        Option<String> lastModified = contentCacheEntry.lastModified();
        etag.foreach((Function1 & Serializable)x$3 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$3));
        lastModified.foreach((Function1 & Serializable)x$4 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$4));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> function1;
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable)() -> "Can't have both a body and body parts!");
        Option<Body> option = httpAttributes.body();
        if (option instanceof Some) {
            Some some = (Some)option;
            Body body = (Body)some.value();
            function1 = session -> (Function1 & Serializable)requestBuilder -> this.setBody((Session)session, (RequestBuilder)requestBuilder, body);
        } else {
            function1 = httpAttributes.bodyParts().nonEmpty() ? session -> (Function1 & Serializable)requestBuilder -> this.configureBodyParts((Session)session, (RequestBuilder)requestBuilder, $this.httpAttributes.bodyParts()) : (httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty() ? session -> (Function1 & Serializable)requestBuilder -> package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams($this.httpAttributes.formParams()), $this.httpAttributes.form(), (Session)session).map((Function1 & Serializable)resolvedFormParams -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(resolvedFormParams))) : RequestExpressionBuilder$.MODULE$.ConfigureIdentity());
        }
        this.configureBody = function1;
        this.configurePriorKnowledge = httpProtocol.enginePart().enableHttp2() ? session -> (Function1 & Serializable)requestBuilder -> {
            Option<Object> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge((Session)session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$3(BoxesRunTime.unboxToBoolean((Object)x$2))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        } : RequestExpressionBuilder$.MODULE$.ConfigureIdentity();
    }
}

