/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.http.MissingNettyHttpHeaderValues$;
import io.gatling.http.client.realm.BasicRealm;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BitSet;
import scala.collection.BitSet$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class HttpHelper$
implements StrictLogging {
    public static final HttpHelper$ MODULE$ = new HttpHelper$();
    private static final String HttpScheme;
    private static final String WsScheme;
    private static final BitSet OkCodes;
    private static final BitSet RedirectStatusCodes;
    private static final Set<String> StandardApplicationTextMimeSubTypes;
    private static final Set<String> StandardApplicationTextExtensions;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        HttpScheme = "http";
        WsScheme = "ws";
        OkCodes = (BitSet)BitSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{HttpResponseStatus.OK.code(), HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.CREATED.code(), HttpResponseStatus.ACCEPTED.code(), HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION.code(), HttpResponseStatus.NO_CONTENT.code(), HttpResponseStatus.RESET_CONTENT.code(), HttpResponseStatus.PARTIAL_CONTENT.code(), HttpResponseStatus.MULTI_STATUS.code(), 208, 209}));
        RedirectStatusCodes = (BitSet)BitSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{HttpResponseStatus.MOVED_PERMANENTLY.code(), HttpResponseStatus.FOUND.code(), HttpResponseStatus.SEE_OTHER.code(), HttpResponseStatus.TEMPORARY_REDIRECT.code(), HttpResponseStatus.PERMANENT_REDIRECT.code()}));
        StandardApplicationTextMimeSubTypes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"javascript", "json", "xml", "x-www-form-urlencoded", "x-javascript"}));
        StandardApplicationTextExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"+xml", "+json"}));
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public String HttpScheme() {
        return HttpScheme;
    }

    public String WsScheme() {
        return WsScheme;
    }

    public BitSet OkCodes() {
        return OkCodes;
    }

    private BitSet RedirectStatusCodes() {
        return RedirectStatusCodes;
    }

    public List<Tuple2<String, String>> parseFormBody(String body) {
        return (List)ArrayOps$.MODULE$.view$extension(Predef$.MODULE$.refArrayOps((Object[])body.split("&"))).map((Function1 & Serializable)x$1 -> x$1.split("=", 2)).map((Function1 & Serializable)pair -> {
            String paramName = HttpHelper$.utf8Decode$1(pair[0]);
            String paramValue = ((String[])pair).length > 1 ? HttpHelper$.utf8Decode$1(pair[1]) : "";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)paramName), (Object)paramValue);
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()));
    }

    public Function1<Session, Validation<Realm>> buildBasicAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return (Function1 & Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable)usernameValue -> ((Validation)password.apply(session)).map((Function1 & Serializable)passwordValue -> new BasicRealm(usernameValue, passwordValue)));
    }

    public Function1<Session, Validation<Realm>> buildDigestAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return (Function1 & Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable)usernameValue -> ((Validation)password.apply(session)).map((Function1 & Serializable)passwordValue -> new DigestRealm(usernameValue, passwordValue)));
    }

    private Option<String> mimeType(HttpHeaders headers) {
        return Option$.MODULE$.apply((Object)headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).map((Function1 & Serializable)contentType -> {
            int comma = contentType.indexOf(59);
            return comma == -1 ? contentType : contentType.substring(0, comma).trim();
        });
    }

    private Set<String> StandardApplicationTextMimeSubTypes() {
        return StandardApplicationTextMimeSubTypes;
    }

    private Set<String> StandardApplicationTextExtensions() {
        return StandardApplicationTextExtensions;
    }

    public boolean isText(HttpHeaders headers) {
        return this.mimeType(headers).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isText$1(headers, x0$1)));
    }

    private boolean isText(String mt) {
        boolean bl;
        Option option;
        String string = mt;
        if (string != null && !(option = new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application/", ""})).s().unapplySeq(string)).isEmpty() && option.get() != null && ((SeqOps)option.get()).lengthCompare(1) == 0) {
            String subType = (String)((SeqOps)option.get()).apply(0);
            bl = this.StandardApplicationTextMimeSubTypes().contains((Object)subType) || this.StandardApplicationTextExtensions().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)subType.endsWith(x$1)));
        } else {
            bl = string.startsWith("text/");
        }
        return bl;
    }

    public boolean isCss(HttpHeaders headers) {
        return this.mimeType(headers).contains((Object)HttpHeaderValues.TEXT_CSS.toString());
    }

    public boolean isHtml(HttpHeaders headers) {
        return this.mimeType(headers).exists((Function1 & Serializable)mt -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isHtml$1(mt)));
    }

    public boolean isAjax(HttpHeaders headers) {
        return headers.contains((CharSequence)HttpHeaderNames.X_REQUESTED_WITH, (CharSequence)MissingNettyHttpHeaderValues$.MODULE$.XmlHttpRequest(), false);
    }

    public Uri resolveFromUri(Uri rootURI, String relative) {
        return relative.startsWith("//") ? Uri.create((String)new StringBuilder(1).append(rootURI.getScheme()).append(":").append(relative).toString()) : Uri.create((Uri)rootURI, (String)relative);
    }

    public Option<Uri> resolveFromUriSilently(Uri rootURI, String relative) {
        Some some;
        try {
            some = new Some((Object)this.resolveFromUri(rootURI, relative));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(45).append("Failed to resolve URI rootURI='").append(rootURI).append("', relative='").append(relative).append("'").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public boolean isOk(int statusCode) {
        return this.OkCodes().contains(statusCode);
    }

    public boolean isRedirect(HttpResponseStatus status) {
        return this.RedirectStatusCodes().contains(status.code());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPermanentRedirect(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.MOVED_PERMANENTLY;
        if (httpResponseStatus == null) {
            if (httpResponseStatus2 == null) return true;
        } else if (httpResponseStatus.equals(httpResponseStatus2)) return true;
        HttpResponseStatus httpResponseStatus3 = status;
        HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.PERMANENT_REDIRECT;
        if (httpResponseStatus3 != null) {
            if (!httpResponseStatus3.equals(httpResponseStatus4)) return false;
            return true;
        }
        if (httpResponseStatus4 == null) return true;
        return false;
    }

    public boolean isNotModified(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_MODIFIED;
        return !(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null);
    }

    public boolean isAbsoluteHttpUrl(String url) {
        return url.startsWith(this.HttpScheme());
    }

    public boolean isAbsoluteWsUrl(String url) {
        return url.startsWith(this.WsScheme());
    }

    public Option<Charset> extractCharsetFromContentType(String contentType) {
        return this.extractParameterFromContentType(contentType, "charset=").flatMap((Function1 & Serializable)charsetString -> {
            Some some;
            try {
                some = new Some((Object)Charset.forName(charsetString));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        });
    }

    private Option<String> extractParameterFromContentType(String contentType, String attributeNameAndEqualChar) {
        None$ none$;
        int n = contentType.indexOf(attributeNameAndEqualChar);
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                int n2;
                int start = n + attributeNameAndEqualChar.length();
                if (contentType.regionMatches(true, start, StandardCharsets.UTF_8.name(), 0, 5)) {
                    none$ = new Some((Object)StandardCharsets.UTF_8.name());
                    break;
                }
                int n3 = contentType.indexOf(59, start);
                switch (n3) {
                    case -1: {
                        n2 = contentType.length();
                        break;
                    }
                    default: {
                        n2 = n3;
                        break;
                    }
                }
                int end = n2;
                while (contentType.charAt(start) == ' ' && start < end) {
                    ++start;
                }
                while (contentType.charAt(end - 1) == ' ' && end > start) {
                    --end;
                }
                if (contentType.charAt(start) == '\"' && start < end) {
                    ++start;
                }
                if (contentType.charAt(end - 1) == '\"' && end > start) {
                    --end;
                }
                String charsetString = contentType.substring(start, end);
                none$ = new Some((Object)charsetString);
                break;
            }
        }
        return none$;
    }

    public List<Cookie> responseCookies(HttpHeaders headers) {
        java.util.List setCookieValues = headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE);
        return setCookieValues.isEmpty() ? package$.MODULE$.Nil() : (List)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(setCookieValues).asScala().view().flatMap((Function1 & Serializable)setCookie -> Option$.MODULE$.apply((Object)ClientCookieDecoder.LAX.decode(setCookie)).toList())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()));
    }

    private static final String utf8Decode$1(String s) {
        return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
    }

    public static final /* synthetic */ boolean $anonfun$isText$1(HttpHeaders headers$1, String x0$1) {
        boolean bl;
        block3: {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1741069880: {
                    if (!"multipart/related".equals(string)) break;
                    bl = Option$.MODULE$.apply((Object)headers$1.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).flatMap((Function1 & Serializable)x$2 -> MODULE$.extractParameterFromContentType((String)x$2, "type=")).exists((Function1 & Serializable)mt -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.MODULE$.isText(mt)));
                    break block3;
                }
            }
            bl = MODULE$.isText(string);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isHtml$1(String mt) {
        String string = mt;
        String string2 = HttpHeaderValues.TEXT_HTML.toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = mt;
        String string4 = HttpHeaderValues.APPLICATION_XHTML.toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private HttpHelper$() {
    }
}

