/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws.fsm;

import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.ws.fsm.NextWsState;
import io.gatling.http.action.ws.fsm.NextWsState$;
import io.gatling.http.action.ws.fsm.SendFrame;
import io.gatling.http.action.ws.fsm.WsClosingState;
import io.gatling.http.action.ws.fsm.WsCrashedState;
import io.gatling.http.action.ws.fsm.WsFsm;
import io.gatling.http.action.ws.fsm.WsPerformingCheckState;
import io.gatling.http.action.ws.fsm.WsState;
import io.gatling.http.check.ws.WsFrameCheck;
import io.gatling.http.check.ws.WsFrameCheckSequence;
import io.gatling.http.client.WebSocket;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001B\u0006\r\u0005eA\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003;\u0001\u0011\u00051\bC\u0003A\u0001\u0011\u0005\u0013\tC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0002\f/NLE\r\\3Ti\u0006$XM\u0003\u0002\u000e\u001d\u0005\u0019am]7\u000b\u0005=\u0001\u0012AA<t\u0015\t\t\"#\u0001\u0004bGRLwN\u001c\u0006\u0003'Q\tA\u0001\u001b;ua*\u0011QCF\u0001\bO\u0006$H.\u001b8h\u0015\u00059\u0012AA5p\u0007\u0001\u00192\u0001\u0001\u000e\u001f!\tYB$D\u0001\r\u0013\tiBBA\u0004XgN#\u0018\r^3\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0012%\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0013\u0002\u0007\r|W.\u0003\u0002(A\ti1\u000b\u001e:jGRdunZ4j]\u001e\u0004\"aG\u0015\n\u0005)b!!B,t\rNl\u0017aB:fgNLwN\u001c\t\u0003[Ej\u0011A\f\u0006\u0003W=R!\u0001\r\u000b\u0002\t\r|'/Z\u0005\u0003e9\u0012qaU3tg&|g.A\u0005xK\n\u001cvnY6fiB\u0011Q\u0007O\u0007\u0002m)\u0011qGE\u0001\u0007G2LWM\u001c;\n\u0005e2$!C,fEN{7m[3u\u0003\u0019a\u0014N\\5u}Q!A(\u0010 @!\tY\u0002\u0001C\u0003\u000e\t\u0001\u0007\u0001\u0006C\u0003,\t\u0001\u0007A\u0006C\u00034\t\u0001\u0007A'A\bp]N+g\u000e\u001a+fqR4%/Y7f)\u0019\u0011U\t\u0016,lYB\u00111dQ\u0005\u0003\t2\u00111BT3yi^\u001b8\u000b^1uK\")a)\u0002a\u0001\u000f\u0006Q\u0011m\u0019;j_:t\u0015-\\3\u0011\u0005!\u000bfBA%P!\tQU*D\u0001L\u0015\ta\u0005$\u0001\u0004=e>|GO\u0010\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+T\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u001b\")Q+\u0002a\u0001\u000f\u00069Q.Z:tC\u001e,\u0007\"B,\u0006\u0001\u0004A\u0016AD2iK\u000e\\7+Z9vK:\u001cWm\u001d\t\u00043z\u000bgB\u0001.]\u001d\tQ5,C\u0001O\u0013\tiV*A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'\u0001\u0002'jgRT!!X'\u0011\u0007\t4\u0007.D\u0001d\u0015\tyAM\u0003\u0002f%\u0005)1\r[3dW&\u0011qm\u0019\u0002\u0015/N4%/Y7f\u0007\",7m[*fcV,gnY3\u0011\u0005\tL\u0017B\u00016d\u0005196O\u0012:b[\u0016\u001c\u0005.Z2l\u0011\u0015YS\u00011\u0001-\u0011\u0015iW\u00011\u0001o\u0003\u0011qW\r\u001f;\u0011\u0005=\fX\"\u00019\u000b\u0005Ey\u0013B\u0001:q\u0005\u0019\t5\r^5p]\u0006\trN\\*f]\u0012\u0014\u0015N\\1ss\u001a\u0013\u0018-\\3\u0015\u000f\t+hO`@\u0002\u0002!)aI\u0002a\u0001\u000f\")QK\u0002a\u0001oB\u0019\u00010_>\u000e\u00035K!A_'\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ad\u0018BA?N\u0005\u0011\u0011\u0015\u0010^3\t\u000b]3\u0001\u0019\u0001-\t\u000b-2\u0001\u0019\u0001\u0017\t\u000b54\u0001\u0019\u00018\u0002'=tG+\u001a=u\rJ\fW.\u001a*fG\u0016Lg/\u001a3\u0015\u000b\t\u000b9!!\u0003\t\u000bU;\u0001\u0019A$\t\u000f\u0005-q\u00011\u0001\u0002\u000e\u0005IA/[7fgR\fW\u000e\u001d\t\u0004q\u0006=\u0011bAA\t\u001b\n!Aj\u001c8h\u0003UygNQ5oCJLhI]1nKJ+7-Z5wK\u0012$RAQA\f\u00033AQ!\u0016\u0005A\u0002]Dq!a\u0003\t\u0001\u0004\ti!A\tp]^+'mU8dW\u0016$8\t\\8tK\u0012$rAQA\u0010\u0003S\ti\u0003C\u0004\u0002\"%\u0001\r!a\t\u0002\t\r|G-\u001a\t\u0004q\u0006\u0015\u0012bAA\u0014\u001b\n\u0019\u0011J\u001c;\t\r\u0005-\u0012\u00021\u0001H\u0003\u0019\u0011X-Y:p]\"9\u00111B\u0005A\u0002\u00055\u0011\u0001F8o\u00072LWM\u001c;DY>\u001cXMU3rk\u0016\u001cH\u000fF\u0004C\u0003g\t)$a\u000e\t\u000b\u0019S\u0001\u0019A$\t\u000b-R\u0001\u0019\u0001\u0017\t\u000b5T\u0001\u0019\u00018")
public final class WsIdleState
extends WsState {
    private final WsFsm fsm;
    private final Session session;
    private final WebSocket webSocket;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextWsState onSendTextFrame(String actionName, String message, List<WsFrameCheckSequence<WsFrameCheck>> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Send text frame {} {}", new Object[]{actionName, message});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long now = this.fsm.clock().nowMillis();
        this.webSocket.sendFrame((WebSocketFrame)new TextWebSocketFrame(message));
        this.fsm.statsEngine().logResponse(session.scenario(), session.groups(), actionName, now, now, (Status)OK$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        List<WsFrameCheckSequence<WsFrameCheck>> list = checkSequences;
        if (!(list instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(session));
        .colon.colon colon2 = (.colon.colon)list;
        WsFrameCheckSequence wsFrameCheckSequence = (WsFrameCheckSequence)colon2.head();
        List remainingCheckSequences = colon2.next$access$1();
        if (wsFrameCheckSequence == null) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(session));
        FiniteDuration timeout = wsFrameCheckSequence.timeout();
        List list2 = wsFrameCheckSequence.checks();
        if (!(list2 instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(session));
        .colon.colon colon3 = (.colon.colon)list2;
        WsFrameCheck currentCheck = (WsFrameCheck)colon3.head();
        List remainingChecks = colon3.next$access$1();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Trigger check after sending text frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fsm.scheduleTimeout(timeout);
        return new NextWsState(new WsPerformingCheckState(this.fsm, this.webSocket, currentCheck, (List<WsFrameCheck>)remainingChecks, now, (List<WsFrameCheckSequence<WsFrameCheck>>)remainingCheckSequences, session, (Either<Action, SendFrame>)package$.MODULE$.Left().apply((Object)next)), NextWsState$.MODULE$.apply$default$2());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextWsState onSendBinaryFrame(String actionName, byte[] message, List<WsFrameCheckSequence<WsFrameCheck>> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Send binary frame {} length={}", new Object[]{actionName, BoxesRunTime.boxToInteger((int)message.length)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long now = this.fsm.clock().nowMillis();
        this.webSocket.sendFrame((WebSocketFrame)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])message)));
        this.fsm.statsEngine().logResponse(session.scenario(), session.groups(), actionName, now, now, (Status)OK$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        List<WsFrameCheckSequence<WsFrameCheck>> list = checkSequences;
        if (!(list instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(session));
        .colon.colon colon2 = (.colon.colon)list;
        WsFrameCheckSequence wsFrameCheckSequence = (WsFrameCheckSequence)colon2.head();
        List remainingCheckSequences = colon2.next$access$1();
        if (wsFrameCheckSequence == null) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(session));
        FiniteDuration timeout = wsFrameCheckSequence.timeout();
        List list2 = wsFrameCheckSequence.checks();
        if (!(list2 instanceof .colon.colon)) return new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(session));
        .colon.colon colon3 = (.colon.colon)list2;
        WsFrameCheck currentCheck = (WsFrameCheck)colon3.head();
        List remainingChecks = colon3.next$access$1();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Trigger check after sending binary frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fsm.scheduleTimeout(timeout);
        return new NextWsState(new WsPerformingCheckState(this.fsm, this.webSocket, currentCheck, (List<WsFrameCheck>)remainingChecks, now, (List<WsFrameCheckSequence<WsFrameCheck>>)remainingCheckSequences, session, (Either<Action, SendFrame>)package$.MODULE$.Left().apply((Object)next)), NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onTextFrameReceived(String message, long timestamp) {
        if (!this.autoReplyTextFrames(message, this.webSocket)) {
            this.logUnmatchedServerMessage(this.session);
        }
        return new NextWsState(this, NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onBinaryFrameReceived(byte[] message, long timestamp) {
        this.logUnmatchedServerMessage(this.session);
        return new NextWsState(this, NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onWebSocketClosed(int code, String reason, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("WebSocket was forcefully closed ({}:{}) by the server while in Idle state", new Object[]{BoxesRunTime.boxToInteger((int)code), reason});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextWsState(new WsCrashedState(this.fsm, (Option<String>)None$.MODULE$), NextWsState$.MODULE$.apply$default$2());
    }

    @Override
    public NextWsState onClientCloseRequest(String actionName, Session session, Action next) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Client requested WebSocket close");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.webSocket.sendFrame((WebSocketFrame)new CloseWebSocketFrame());
        return new NextWsState(new WsClosingState(this.fsm, actionName, session, next, this.fsm.clock().nowMillis()), NextWsState$.MODULE$.apply$default$2());
    }

    public WsIdleState(WsFsm fsm, Session session, WebSocket webSocket) {
        this.fsm = fsm;
        this.session = session;
        this.webSocket = webSocket;
        super(fsm);
    }
}

