/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.s3.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.s3.runtime.S3Config;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

@Recorder
public class S3Recorder
extends AmazonClientRecorder {
    final S3Config config;

    public S3Recorder(S3Config config) {
        this.config = config;
    }

    public RuntimeValue<AwsConfig> getAwsConfig() {
        return new RuntimeValue((Object)this.config.aws());
    }

    public RuntimeValue<SdkConfig> getSdkConfig() {
        return new RuntimeValue((Object)this.config.sdk());
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        S3ClientBuilder builder = S3Client.builder();
        this.configureS3Client((S3BaseClientBuilder)builder);
        return builder;
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        this.configureS3Client((S3BaseClientBuilder)builder);
        return builder;
    }

    public RuntimeValue<SdkPresigner.Builder> createPresignerBuilder() {
        S3Presigner.Builder builder = S3Presigner.builder().serviceConfiguration((S3Configuration)this.s3ConfigurationBuilder().build()).dualstackEnabled(Boolean.valueOf(this.config.dualstack()));
        return new RuntimeValue((Object)builder);
    }

    private void configureS3Client(S3BaseClientBuilder builder) {
        builder.serviceConfiguration((S3Configuration)this.s3ConfigurationBuilder().build()).dualstackEnabled(Boolean.valueOf(this.config.dualstack()));
    }

    private S3Configuration.Builder s3ConfigurationBuilder() {
        S3Configuration.Builder s3ConfigBuilder = S3Configuration.builder().accelerateModeEnabled(Boolean.valueOf(this.config.accelerateMode())).checksumValidationEnabled(Boolean.valueOf(this.config.checksumValidation())).chunkedEncodingEnabled(Boolean.valueOf(this.config.chunkedEncoding())).pathStyleAccessEnabled(Boolean.valueOf(this.config.pathStyleAccess())).useArnRegionEnabled(Boolean.valueOf(this.config.useArnRegionEnabled()));
        this.config.profileName().ifPresent(arg_0 -> ((S3Configuration.Builder)s3ConfigBuilder).profileName(arg_0));
        return s3ConfigBuilder;
    }
}

