/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime;

import io.quarkus.reactivemessaging.http.runtime.HttpCloudEventHelper;
import io.quarkus.reactivemessaging.http.runtime.IncomingHttpMetadata;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

class HttpMessage<T>
implements Message<T> {
    private final T payload;
    private final Runnable successHandler;
    private final Consumer<Throwable> failureHandler;
    private final Metadata metadata;

    HttpMessage(T payload, IncomingHttpMetadata requestMetadata, Runnable successHandler, Consumer<Throwable> failureHandler) {
        this.payload = payload;
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
        this.metadata = HttpCloudEventHelper.getBinaryCloudEvent(requestMetadata).map(m -> Metadata.of((Object[])new Object[]{requestMetadata, m})).orElse(Metadata.of((Object[])new Object[]{requestMetadata}));
    }

    public T getPayload() {
        return this.payload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return () -> {
            this.successHandler.run();
            return CompletableFuture.completedFuture(null);
        };
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return error -> {
            this.failureHandler.accept((Throwable)error);
            return CompletableFuture.completedFuture(null);
        };
    }
}

