/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.deployment.pkg.steps.ReportAnalyzer;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="analyze-call-tree")
public class AnalyseCallTreeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${class}")
    private String className;
    @Parameter(defaultValue="${method}")
    private String methodName;
    @Parameter(defaultValue="${project.build.directory}/reports")
    private File reportsDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] files;
        if (this.methodName != null && this.className != null) {
            throw new MojoFailureException("Cannot specify both class and method name");
        }
        String clazz = this.className;
        String method = "<init>";
        if (this.methodName != null) {
            int index = this.methodName.lastIndexOf(46);
            clazz = this.methodName.substring(0, index);
            method = this.methodName.substring(index + 1);
        }
        if ((files = this.reportsDir.listFiles()) == null) {
            throw new MojoFailureException("No reports in " + this.reportsDir);
        }
        for (File i : files) {
            if (!i.getName().startsWith("call_tree")) continue;
            try {
                System.out.println(new ReportAnalyzer(i.getAbsolutePath()).analyse(clazz, method));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed", e);
            }
        }
    }
}

