/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled;
import io.quarkus.deployment.pkg.steps.ErrorReplacingProcessReader;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class NativeImageBuildStep {
    private static final Logger log = Logger.getLogger(NativeImageBuildStep.class);
    private static final String DEBUG_BUILD_PROCESS_PORT = "5005";
    private static final String GRAALVM_HOME = "GRAALVM_HOME";
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final String PATH = "PATH";
    private static final int OOM_ERROR_VALUE = 137;
    private static final String QUARKUS_XMX_PROPERTY = "quarkus.native.native-image-xmx";
    private static final String CONTAINER_BUILD_VOLUME_PATH = "/project";
    private static final String TRUST_STORE_SYSTEM_PROPERTY_MARKER = "-Djavax.net.ssl.trustStore=";
    private static final String MOVED_TRUST_STORE_NAME = "trustStore";
    public static final String APP_SOURCES = "app-sources";

    @BuildStep(onlyIf={NativeBuild.class})
    ArtifactResultBuildItem result(NativeImageBuildItem image) {
        return new ArtifactResultBuildItem(image.getPath(), "native", Collections.emptyMap());
    }

    @BuildStep
    public NativeImageBuildItem build(NativeConfig nativeConfig, NativeImageSourceJarBuildItem nativeImageSourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<NativeImageSystemPropertyBuildItem> nativeImageProperties, Optional<ProcessInheritIODisabled> processInheritIODisabled) {
        List<String> nativeImage;
        GraalVM.Version graalVMVersion;
        boolean isContainerBuild;
        if (nativeConfig.debug.enabled) {
            this.copyJarSourcesToLib(outputTargetBuildItem, curateOutcomeBuildItem);
            NativeImageBuildStep.copySourcesToSourceCache(outputTargetBuildItem);
        }
        Path runnerJar = nativeImageSourceJarBuildItem.getPath();
        log.info((Object)("Building native image from " + runnerJar));
        Path outputDir = nativeImageSourceJarBuildItem.getPath().getParent();
        String runnerJarName = runnerJar.getFileName().toString();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String noPIE = "";
        boolean bl = isContainerBuild = nativeConfig.containerRuntime.isPresent() || nativeConfig.containerBuild;
        if (!isContainerBuild && SystemUtils.IS_OS_LINUX) {
            noPIE = NativeImageBuildStep.detectNoPIE();
        }
        if ((graalVMVersion = GraalVM.Version.ofBinary(nativeImage = NativeImageBuildStep.getNativeImage(nativeConfig, processInheritIODisabled, outputDir, env))).isDetected()) {
            this.checkGraalVMVersion(graalVMVersion);
        } else {
            log.error((Object)"Unable to get GraalVM version from the native-image binary.");
        }
        try {
            ArrayList<String> command = new ArrayList<String>(nativeImage);
            if (nativeConfig.cleanupServer && !graalVMVersion.isMandrel()) {
                ArrayList<String> cleanup = new ArrayList<String>(nativeImage);
                cleanup.add("--server-shutdown");
                ProcessBuilder pb = new ProcessBuilder(cleanup.toArray(new String[0]));
                pb.directory(outputDir.toFile());
                Process process = ProcessUtil.launchProcess(pb, processInheritIODisabled.isPresent());
                process.waitFor();
            }
            boolean enableSslNative = false;
            for (NativeImageSystemPropertyBuildItem prop : nativeImageProperties) {
                if (prop.getKey().equals("quarkus.ssl.native") && prop.getValue() != null) {
                    enableSslNative = Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getKey().equals("quarkus.jni.enable") && prop.getValue().equals("false")) {
                    log.warn((Object)"Your application is setting the deprecated 'quarkus.jni.enable' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
                    continue;
                }
                if (prop.getKey().equals("quarkus.native.enable-all-security-services") && prop.getValue() != null) {
                    nativeConfig.enableAllSecurityServices |= Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getKey().equals("quarkus.native.enable-all-charsets") && prop.getValue() != null) {
                    nativeConfig.addAllCharsets |= Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getValue() == null) {
                    command.add("-J-D" + prop.getKey());
                    continue;
                }
                command.add("-J-D" + prop.getKey() + "=" + prop.getValue());
            }
            if (nativeConfig.userLanguage.isPresent()) {
                command.add("-J-Duser.language=" + nativeConfig.userLanguage.get());
            }
            if (nativeConfig.userCountry.isPresent()) {
                command.add("-J-Duser.country=" + nativeConfig.userCountry.get());
            }
            command.add("-J-Dfile.encoding=" + nativeConfig.fileEncoding);
            if (enableSslNative) {
                nativeConfig.enableHttpsUrlHandler = true;
                nativeConfig.enableAllSecurityServices = true;
            }
            this.handleAdditionalProperties(nativeConfig, command, isContainerBuild, outputDir);
            command.add("--initialize-at-build-time=");
            command.add("-H:InitialCollectionPolicy=com.oracle.svm.core.genscavenge.CollectionPolicy$BySpaceAndTime");
            command.add("-H:+JNI");
            command.add("-H:+AllowFoldMethods");
            command.add("-jar");
            command.add(runnerJarName);
            if (nativeConfig.enableFallbackImages) {
                command.add("-H:FallbackThreshold=5");
            } else {
                command.add("-H:FallbackThreshold=0");
            }
            if (nativeConfig.reportErrorsAtRuntime) {
                command.add("-H:+ReportUnsupportedElementsAtRuntime");
            }
            if (nativeConfig.reportExceptionStackTraces) {
                command.add("-H:+ReportExceptionStackTraces");
            }
            if (nativeConfig.debug.enabled) {
                command.add("-g");
                command.add("-H:DebugInfoSourceSearchPath=app-sources");
            }
            if (nativeConfig.debugBuildProcess) {
                command.add("-J-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=y");
            }
            if (nativeConfig.enableReports) {
                command.add("-H:+PrintAnalysisCallTree");
            }
            if (nativeConfig.dumpProxies) {
                command.add("-Dsun.misc.ProxyGenerator.saveGeneratedFiles=true");
                if (nativeConfig.enableServer) {
                    log.warn((Object)"Options dumpProxies and enableServer are both enabled: this will get the proxies dumped in an unknown external working directory");
                }
            }
            if (nativeConfig.nativeImageXmx.isPresent()) {
                command.add("-J-Xmx" + nativeConfig.nativeImageXmx.get());
            }
            ArrayList<String> protocols = new ArrayList<String>(2);
            if (nativeConfig.enableHttpUrlHandler) {
                protocols.add("http");
            }
            if (nativeConfig.enableHttpsUrlHandler) {
                protocols.add("https");
            }
            if (nativeConfig.addAllCharsets) {
                command.add("-H:+AddAllCharsets");
            } else {
                command.add("-H:-AddAllCharsets");
            }
            if (!protocols.isEmpty()) {
                command.add("-H:EnableURLProtocols=" + String.join((CharSequence)",", protocols));
            }
            if (nativeConfig.enableAllSecurityServices) {
                command.add("--enable-all-security-services");
            }
            if (!noPIE.isEmpty()) {
                command.add("-H:NativeLinkerOption=" + noPIE);
            }
            if (!nativeConfig.enableIsolates) {
                command.add("-H:-SpawnIsolates");
            }
            if (!nativeConfig.enableJni) {
                log.warn((Object)"Your application is setting the deprecated 'quarkus.native.enable-jni' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
            }
            if (!(nativeConfig.enableServer || SystemUtils.IS_OS_WINDOWS || graalVMVersion.isMandrel())) {
                command.add("--no-server");
            }
            if (nativeConfig.enableVmInspection) {
                command.add("-H:+AllowVMInspection");
            }
            if (nativeConfig.autoServiceLoaderRegistration) {
                command.add("-H:+UseServiceLoaderFeature");
                command.add("-H:+TraceServiceLoaderFeature");
            } else {
                command.add("-H:-UseServiceLoaderFeature");
            }
            if (nativeConfig.fullStackTraces) {
                command.add("-H:+StackTrace");
            } else {
                command.add("-H:-StackTrace");
            }
            if (nativeConfig.enableDashboardDump) {
                command.add("-H:DashboardDump=" + outputTargetBuildItem.getBaseName() + "_dashboard.dump");
                command.add("-H:+DashboardAll");
            }
            String executableName = outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix;
            command.add(executableName);
            log.info((Object)String.join((CharSequence)" ", command).replace("$", "\\$"));
            CountDownLatch errorReportLatch = new CountDownLatch(1);
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(outputDir.toFile());
            Process process = ProcessUtil.launchProcessStreamStdOut(processBuilder, processInheritIODisabled.isPresent());
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new ErrorReplacingProcessReader(process.getErrorStream(), outputDir.resolve("reports").toFile(), errorReportLatch));
            executor.shutdown();
            errorReportLatch.await();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw this.imageGenerationFailed(exitCode, command);
            }
            if (SystemUtils.IS_OS_WINDOWS && !isContainerBuild) {
                executableName = executableName + ".exe";
            }
            Path generatedImage = outputDir.resolve(executableName);
            Path finalPath = outputTargetBuildItem.getOutputDirectory().resolve(executableName);
            IoUtils.copy((Path)generatedImage, (Path)finalPath);
            Files.delete(generatedImage);
            if (nativeConfig.debug.enabled) {
                String sources = "sources";
                Path generatedSources = outputDir.resolve("sources");
                Path finalSources = outputTargetBuildItem.getOutputDirectory().resolve("sources");
                IoUtils.copy((Path)generatedSources, (Path)finalSources);
                IoUtils.recursiveDelete((Path)generatedSources);
            }
            System.setProperty("native.image.path", finalPath.toAbsolutePath().toString());
            if (this.objcopyExists(env)) {
                if (nativeConfig.debug.enabled) {
                    this.splitDebugSymbols(finalPath);
                }
                NativeImageBuildStep.objcopy("--strip-debug", finalPath.toString());
            } else {
                log.warn((Object)"objcopy executable not found in PATH. Debug symbols will not be separated from executable.");
                log.warn((Object)"That will result in a larger native image with debug symbols embedded in it.");
            }
            NativeImageBuildItem nativeImageBuildItem = new NativeImageBuildItem(finalPath);
            return nativeImageBuildItem;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build native image", e);
        }
        finally {
            if (nativeConfig.debug.enabled) {
                this.removeJarSourcesFromLib(outputTargetBuildItem);
                IoUtils.recursiveDelete((Path)outputDir.resolve(Paths.get(APP_SOURCES, new String[0])));
            }
        }
    }

    private static List<String> getNativeImage(NativeConfig nativeConfig, Optional<ProcessInheritIODisabled> processInheritIODisabled, Path outputDir, Map<String, String> env) {
        boolean isContainerBuild;
        boolean bl = isContainerBuild = nativeConfig.containerRuntime.isPresent() || nativeConfig.containerBuild;
        if (isContainerBuild) {
            return NativeImageBuildStep.setupContainerBuild(nativeConfig, processInheritIODisabled, outputDir);
        }
        Optional<String> graal = nativeConfig.graalvmHome;
        File java = nativeConfig.javaHome;
        if (graal.isPresent()) {
            env.put(GRAALVM_HOME, graal.get());
        }
        if (java == null) {
            String home = System.getProperty(JAVA_HOME_SYS);
            if (home == null) {
                home = env.get(JAVA_HOME_ENV);
            }
            if (home != null) {
                java = new File(home);
            }
        }
        return NativeImageBuildStep.getNativeImageExecutable(graal, java, env, nativeConfig, processInheritIODisabled, outputDir);
    }

    public static List<String> setupContainerBuild(NativeConfig nativeConfig, Optional<ProcessInheritIODisabled> processInheritIODisabled, Path outputDir) {
        NativeConfig.ContainerRuntime containerRuntime = nativeConfig.containerRuntime.orElseGet(NativeImageBuildStep::detectContainerRuntime);
        log.infof("Using %s to run the native image builder", (Object)containerRuntime.getExecutableName());
        ArrayList<String> nativeImage = new ArrayList<String>();
        String outputPath = outputDir.toAbsolutePath().toString();
        if (SystemUtils.IS_OS_WINDOWS) {
            outputPath = FileUtil.translateToVolumePath(outputPath);
        }
        Collections.addAll(nativeImage, containerRuntime.getExecutableName(), "run", "-v", outputPath + ":" + CONTAINER_BUILD_VOLUME_PATH + ":z", "--env", "LANG=C");
        if (SystemUtils.IS_OS_LINUX) {
            String uid = LinuxIDUtil.getLinuxID("-ur");
            String gid = LinuxIDUtil.getLinuxID("-gr");
            if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                Collections.addAll(nativeImage, "--user", uid + ":" + gid);
                if (containerRuntime == NativeConfig.ContainerRuntime.PODMAN) {
                    nativeImage.add("--userns=keep-id");
                }
            }
        }
        nativeConfig.containerRuntimeOptions.ifPresent(nativeImage::addAll);
        if (nativeConfig.debugBuildProcess && nativeConfig.publishDebugBuildProcessPort) {
            nativeImage.add("--publish=5005:5005");
        }
        Collections.addAll(nativeImage, "--rm", nativeConfig.builderImage);
        if (containerRuntime == NativeConfig.ContainerRuntime.DOCKER || containerRuntime == NativeConfig.ContainerRuntime.PODMAN) {
            log.info((Object)("Checking image status " + nativeConfig.builderImage));
            Process pullProcess = null;
            try {
                ProcessBuilder pb = new ProcessBuilder(Arrays.asList(containerRuntime.getExecutableName(), "pull", nativeConfig.builderImage));
                pullProcess = ProcessUtil.launchProcess(pb, processInheritIODisabled.isPresent());
                pullProcess.waitFor();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to pull builder image " + nativeConfig.builderImage, e);
            }
            finally {
                if (pullProcess != null) {
                    pullProcess.destroy();
                }
            }
        }
        return nativeImage;
    }

    private static NativeConfig.ContainerRuntime detectContainerRuntime() {
        String dockerVersionOutput = NativeImageBuildStep.getVersionOutputFor(NativeConfig.ContainerRuntime.DOCKER);
        boolean dockerAvailable = dockerVersionOutput.contains("Docker version");
        String podmanVersionOutput = NativeImageBuildStep.getVersionOutputFor(NativeConfig.ContainerRuntime.PODMAN);
        boolean podmanAvailable = podmanVersionOutput.startsWith("podman version");
        if (dockerAvailable) {
            if (dockerVersionOutput.equals(podmanVersionOutput)) {
                return NativeConfig.ContainerRuntime.PODMAN;
            }
            return NativeConfig.ContainerRuntime.DOCKER;
        }
        if (podmanAvailable) {
            return NativeConfig.ContainerRuntime.PODMAN;
        }
        throw new IllegalStateException("No container runtime was found to run the native image builder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionOutputFor(NativeConfig.ContainerRuntime containerRuntime) {
        Process versionProcess = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(containerRuntime.getExecutableName(), "--version").redirectErrorStream(true);
            versionProcess = pb.start();
            versionProcess.waitFor();
            String string = new String(FileUtil.readFileContents(versionProcess.getInputStream()), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException | InterruptedException e) {
            log.debugf((Throwable)e, "Failure to read version output from %s", (Object)containerRuntime.getExecutableName());
            String string = "";
            return string;
        }
        finally {
            if (versionProcess != null) {
                versionProcess.destroy();
            }
        }
    }

    private void copyJarSourcesToLib(OutputTargetBuildItem outputTargetBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path libDir = targetDirectory.resolve("lib");
        File libDirFile = libDir.toFile();
        if (!libDirFile.exists()) {
            libDirFile.mkdirs();
        }
        List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        for (AppDependency appDep : appDeps) {
            AppArtifact depArtifact = appDep.getArtifact();
            if (!depArtifact.getType().equals("jar")) continue;
            for (Path resolvedDep : depArtifact.getPaths()) {
                Path jarSourceDep;
                if (Files.isDirectory(resolvedDep, new LinkOption[0]) || !(jarSourceDep = NativeImageBuildStep.toJarSource(resolvedDep)).toFile().exists()) continue;
                String fileName = depArtifact.getGroupId() + "." + jarSourceDep.getFileName();
                Path targetPath = libDir.resolve(fileName);
                try {
                    Files.copy(jarSourceDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to copy from " + jarSourceDep + " to " + targetPath, e);
                }
            }
        }
    }

    private static Path toJarSource(Path path) {
        Path parent = path.getParent();
        String fileName = path.getFileName().toString();
        int extensionIndex = fileName.lastIndexOf(46);
        String sourcesFileName = String.format("%s-sources.jar", fileName.substring(0, extensionIndex));
        return parent.resolve(sourcesFileName);
    }

    private void removeJarSourcesFromLib(OutputTargetBuildItem outputTargetBuildItem) {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path libDir = targetDirectory.resolve("lib");
        File[] jarSources = libDir.toFile().listFiles((file, name) -> name.endsWith("-sources.jar"));
        Stream.of((Object[])Objects.requireNonNull(jarSources)).forEach(File::delete);
    }

    private static void copySourcesToSourceCache(OutputTargetBuildItem outputTargetBuildItem) {
        Path javaSourcesPath;
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path targetSrc = targetDirectory.resolve(Paths.get(APP_SOURCES, new String[0]));
        File targetSrcFile = targetSrc.toFile();
        if (!targetSrcFile.exists()) {
            targetSrcFile.mkdirs();
        }
        if (Files.exists(javaSourcesPath = outputTargetBuildItem.getOutputDirectory().resolve(Paths.get("..", "src", "main", "java")), new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(javaSourcesPath, new FileVisitOption[0]);){
                paths.forEach(path -> {
                    Path targetPath = Paths.get(targetSrc.toString(), path.toString().substring(javaSourcesPath.toString().length()));
                    try {
                        Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to copy from " + path + " to " + targetPath, e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to walk path " + javaSourcesPath, e);
            }
        }
    }

    private void handleAdditionalProperties(NativeConfig nativeConfig, List<String> command, boolean isContainerBuild, Path outputDir) {
        if (nativeConfig.additionalBuildArgs.isPresent()) {
            List<String> strings = nativeConfig.additionalBuildArgs.get();
            for (String buildArg : strings) {
                String trimmedBuildArg = buildArg.trim();
                if (trimmedBuildArg.contains(TRUST_STORE_SYSTEM_PROPERTY_MARKER) && isContainerBuild) {
                    int index = trimmedBuildArg.indexOf(TRUST_STORE_SYSTEM_PROPERTY_MARKER);
                    if (trimmedBuildArg.length() <= index + 2) continue;
                    String configuredTrustStorePath = trimmedBuildArg.substring(index + TRUST_STORE_SYSTEM_PROPERTY_MARKER.length());
                    try {
                        IoUtils.copy((Path)Paths.get(configuredTrustStorePath, new String[0]), (Path)outputDir.resolve(MOVED_TRUST_STORE_NAME));
                        command.add(trimmedBuildArg.substring(0, index) + TRUST_STORE_SYSTEM_PROPERTY_MARKER + CONTAINER_BUILD_VOLUME_PATH + "/" + MOVED_TRUST_STORE_NAME);
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to copy trustStore file '" + configuredTrustStorePath + "' to volume root directory '" + outputDir.toAbsolutePath().toString() + "'", e);
                    }
                }
                command.add(trimmedBuildArg);
            }
        }
    }

    private RuntimeException imageGenerationFailed(int exitValue, List<String> command) {
        if (exitValue == 137) {
            if (command.contains("docker") && !SystemUtils.IS_OS_LINUX) {
                return new RuntimeException("Image generation failed. Exit code was " + exitValue + " which indicates an out of memory error. The most likely cause is Docker not being given enough memory. Also consider increasing the Xmx value for native image generation by setting the \"" + QUARKUS_XMX_PROPERTY + "\" property");
            }
            return new RuntimeException("Image generation failed. Exit code was " + exitValue + " which indicates an out of memory error. Consider increasing the Xmx value for native image generation by setting the \"" + QUARKUS_XMX_PROPERTY + "\" property");
        }
        return new RuntimeException("Image generation failed. Exit code: " + exitValue);
    }

    private void checkGraalVMVersion(GraalVM.Version version) {
        log.info((Object)("Running Quarkus native-image plugin on " + version.getFullVersion()));
        if (version.isObsolete()) {
            int major = GraalVM.Version.CURRENT.major;
            int minor = GraalVM.Version.CURRENT.minor;
            throw new IllegalStateException("Out of date version of GraalVM detected: " + version.getFullVersion() + ". Quarkus currently supports " + major + "." + minor + ". Please upgrade GraalVM to this version.");
        }
    }

    private static List<String> getNativeImageExecutable(Optional<String> graalVmHome, File javaHome, Map<String, String> env, NativeConfig nativeConfig, Optional<ProcessInheritIODisabled> processInheritIODisabled, Path outputDir) {
        File file;
        String imageName;
        String string = imageName = SystemUtils.IS_OS_WINDOWS ? "native-image.cmd" : "native-image";
        if (graalVmHome.isPresent() && (file = Paths.get(graalVmHome.get(), "bin", imageName).toFile()).exists()) {
            return Collections.singletonList(file.getAbsolutePath());
        }
        if (javaHome != null && (file = new File(javaHome, "bin/" + imageName)).exists()) {
            return Collections.singletonList(file.getAbsolutePath());
        }
        String systemPath = env.get(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file2;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file2 = new File(dir, imageName)).exists()) continue;
                return Collections.singletonList(file2.getAbsolutePath());
            }
        }
        if (SystemUtils.IS_OS_LINUX) {
            log.warn((Object)("Cannot find the `" + imageName + "` in the GRAALVM_HOME, JAVA_HOME and System PATH. Install it using `gu install native-image`. Attempting to fall back to docker."));
            return NativeImageBuildStep.setupContainerBuild(nativeConfig, processInheritIODisabled, outputDir);
        }
        throw new RuntimeException("Cannot find the `" + imageName + "` in the GRAALVM_HOME, JAVA_HOME and System PATH. Install it using `gu install native-image`");
    }

    private static String detectNoPIE() {
        String argument = NativeImageBuildStep.testGCCArgument("-no-pie");
        return argument.length() == 0 ? NativeImageBuildStep.testGCCArgument("-nopie") : argument;
    }

    private static String testGCCArgument(String argument) {
        try {
            Process gcc = new ProcessBuilder("cc", "-v", "-E", argument, "-").start();
            gcc.getOutputStream().close();
            if (gcc.waitFor() == 0) {
                return argument;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }

    private boolean objcopyExists(Map<String, String> env) {
        String systemPath = env.get(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file = new File(dir, "objcopy")).exists()) continue;
                return true;
            }
        }
        return false;
    }

    private void splitDebugSymbols(Path executable) {
        Path symbols = Paths.get(String.format("%s.debug", executable.toString()), new String[0]);
        NativeImageBuildStep.objcopy("--only-keep-debug", executable.toString(), symbols.toString());
        NativeImageBuildStep.objcopy(String.format("--add-gnu-debuglink=%s", symbols.toString()), executable.toString());
    }

    private static void objcopy(String ... args) {
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add("objcopy");
        command.addAll(Arrays.asList(args));
        if (log.isDebugEnabled()) {
            log.debugf("Execute %s", (Object)String.join((CharSequence)" ", command));
        }
        Process process = null;
        try {
            process = new ProcessBuilder(command).start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to invoke objcopy", e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    protected static final class GraalVM {
        protected GraalVM() {
        }

        static enum Distribution {
            ORACLE,
            MANDREL;

        }

        static final class Version
        implements Comparable<Version> {
            private static final Pattern PATTERN = Pattern.compile("GraalVM Version (([1-9][0-9]*)\\.([0-9]+)\\.[0-9]+|\\p{XDigit}*)[^(\n$]*(\\(Mandrel Distribution\\))?\\s*");
            static final Version UNVERSIONED = new Version("Undefined", -1, -1, Distribution.ORACLE);
            static final Version SNAPSHOT_ORACLE = new Version("Snapshot", Integer.MAX_VALUE, Integer.MAX_VALUE, Distribution.ORACLE);
            static final Version SNAPSHOT_MANDREL = new Version("Snapshot", Integer.MAX_VALUE, Integer.MAX_VALUE, Distribution.MANDREL);
            static final Version VERSION_20_3 = new Version("GraalVM 20.3", 20, 3, Distribution.ORACLE);
            static final Version VERSION_21_0 = new Version("GraalVM 21.0", 21, 0, Distribution.ORACLE);
            static final Version MINIMUM = VERSION_20_3;
            static final Version CURRENT = VERSION_21_0;
            final String fullVersion;
            final int major;
            final int minor;
            final Distribution distribution;

            Version(String fullVersion, int major, int minor, Distribution distro) {
                this.fullVersion = fullVersion;
                this.major = major;
                this.minor = minor;
                this.distribution = distro;
            }

            String getFullVersion() {
                return this.fullVersion;
            }

            boolean isDetected() {
                return this != UNVERSIONED;
            }

            boolean isObsolete() {
                return this.compareTo(MINIMUM) < 0;
            }

            boolean isMandrel() {
                return this.distribution == Distribution.MANDREL;
            }

            boolean isSnapshot() {
                return this == SNAPSHOT_ORACLE || this == SNAPSHOT_MANDREL;
            }

            boolean isNewerThan(Version version) {
                return this.compareTo(version) > 0;
            }

            @Override
            public int compareTo(Version o) {
                if (this.major > o.major) {
                    return 1;
                }
                if (this.major == o.major) {
                    if (this.minor > o.minor) {
                        return 1;
                    }
                    if (this.minor == o.minor) {
                        return 0;
                    }
                }
                return -1;
            }

            static Version of(Stream<String> lines) {
                Iterator it = lines.iterator();
                while (it.hasNext()) {
                    String line = (String)it.next();
                    Matcher matcher = PATTERN.matcher(line);
                    if (!matcher.find() || matcher.groupCount() < 3) continue;
                    String distro = matcher.group(4);
                    if (Version.isSnapshot(matcher.group(2))) {
                        return Version.isMandrel(distro) ? SNAPSHOT_MANDREL : SNAPSHOT_ORACLE;
                    }
                    return new Version(line, Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Version.isMandrel(distro) ? Distribution.MANDREL : Distribution.ORACLE);
                }
                return UNVERSIONED;
            }

            private static Version ofBinary(List<String> nativeImage) {
                Version graalVMVersion;
                try {
                    ArrayList<String> versionCommand = new ArrayList<String>(nativeImage);
                    versionCommand.add("--version");
                    Process versionProcess = new ProcessBuilder(versionCommand.toArray(new String[0])).redirectErrorStream(true).start();
                    versionProcess.waitFor();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(versionProcess.getInputStream(), StandardCharsets.UTF_8));){
                        graalVMVersion = Version.of(reader.lines());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get GraalVM version", e);
                }
                return graalVMVersion;
            }

            private static boolean isSnapshot(String s) {
                return s == null;
            }

            private static boolean isMandrel(String s) {
                return "(Mandrel Distribution)".equals(s);
            }

            public String toString() {
                return "Version{major=" + this.major + ", minor=" + this.minor + ", distribution=" + (Object)((Object)this.distribution) + '}';
            }
        }
    }
}

