/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.tracker;

import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingValueTransformer;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ConfigTrackingWriter {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static boolean matches(String name, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public static void write(Map<String, String> readOptions, ConfigTrackingConfig config, BuildTimeConfigurationReader.ReadResult configReadResult, LaunchMode launchMode, Path buildDirectory) {
        if (!config.enabled()) {
            return;
        }
        Path file = config.file().orElse(null);
        if (file == null) {
            Path dir = config.directory().orElseGet(() -> (buildDirectory.getParent() == null ? buildDirectory : buildDirectory.getParent()).resolve(".quarkus"));
            file = dir.resolve(config.filePrefix() + "-" + launchMode.getDefaultProfile() + config.fileSuffix());
        } else if (!file.isAbsolute()) {
            file = config.directory().orElse(buildDirectory).resolve(file);
        }
        if (file.getParent() != null) {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ConfigTrackingWriter.write(readOptions, config, configReadResult, file);
    }

    public static void write(Map<String, String> readOptions, ConfigTrackingConfig config, BuildTimeConfigurationReader.ReadResult configReadResult, Path file) {
        List<Pattern> excludePatterns = config.getExcludePatterns();
        ConfigTrackingValueTransformer valueTransformer = ConfigTrackingValueTransformer.newInstance(config);
        Map<String, String> allBuildTimeValues = configReadResult.getAllBuildTimeValues();
        Map<String, String> buildTimeRuntimeValues = configReadResult.getBuildTimeRunTimeValues();
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            ArrayList<String> names = new ArrayList<String>(readOptions.size());
            for (String name : readOptions.keySet()) {
                if (!allBuildTimeValues.containsKey(name) && !buildTimeRuntimeValues.containsKey(name) || ConfigTrackingWriter.matches(name, excludePatterns)) continue;
                names.add(name);
            }
            Collections.sort(names);
            for (String name : names) {
                String value = valueTransformer.transform(name, readOptions.get(name));
                ConfigTrackingWriter.write(writer, name, value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Writer writer, String name, String value) throws IOException {
        if (value != null) {
            name = ConfigTrackingWriter.toWritableValue(name, true, true);
            value = ConfigTrackingWriter.toWritableValue(value, false, true);
            writer.write(name);
            writer.write("=");
            writer.write(value);
            writer.write(System.lineSeparator());
        }
    }

    private static String toWritableValue(String str, boolean escapeSpace, boolean escapeUnicode) {
        int len = str.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = str.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(ConfigTrackingWriter.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(ConfigTrackingWriter.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(ConfigTrackingWriter.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(ConfigTrackingWriter.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

