/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.selection;

import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginWithPreference;
import java.util.ArrayList;
import java.util.List;

public class OriginSelector {
    private final List<ExtensionOrigins> extOrigins;
    private final List<OriginCombination> completeCombinations = new ArrayList<OriginCombination>();
    private int highestRegistryPreference;

    public OriginSelector(List<ExtensionOrigins> extOrigins) {
        this.extOrigins = extOrigins;
    }

    public void calculateCompatibleCombinations() {
        if (this.extOrigins.isEmpty()) {
            return;
        }
        this.select(0, new OriginCombination());
    }

    public OriginCombination getRecommendedCombination() {
        if (this.completeCombinations.isEmpty()) {
            return null;
        }
        if (this.completeCombinations.size() == 1) {
            return this.completeCombinations.get(0);
        }
        double highestScore = 0.0;
        OriginCombination recommended = null;
        for (OriginCombination combination : this.completeCombinations) {
            double score = this.calculateScore(combination);
            if (!(score > highestScore)) continue;
            highestScore = score;
            recommended = combination;
        }
        return recommended;
    }

    private double calculateScore(OriginCombination s) {
        double combinationScore = 0.0;
        for (OriginWithPreference o : s.getCollectedOrigins()) {
            combinationScore += Math.pow(this.extOrigins.size(), this.highestRegistryPreference + 1 - o.getPreference().registryPreference) * ((double)(Integer.MIN_VALUE - o.getPreference().platformPreference) / 2.147483647E9);
        }
        return combinationScore;
    }

    private void select(int extIndex, OriginCombination combination) {
        if (extIndex >= this.extOrigins.size()) {
            throw new IllegalArgumentException("Extension index " + extIndex + " exceeded the total number of extensions " + this.extOrigins.size());
        }
        ExtensionOrigins eo = this.extOrigins.get(extIndex);
        for (OriginWithPreference o : eo.getOrigins()) {
            this.highestRegistryPreference = Math.max(this.highestRegistryPreference, o.getPreference().registryPreference);
            OriginCombination augmentedCombination = combination.add(eo.getExtensionKey(), o);
            if (augmentedCombination == null) continue;
            if (this.extOrigins.size() == augmentedCombination.size()) {
                this.completeCombinations.add(augmentedCombination);
                continue;
            }
            if (extIndex + 1 == this.extOrigins.size()) {
                return;
            }
            this.select(extIndex + 1, augmentedCombination);
        }
    }
}

