/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.quarkus.registry.config.json.JsonRegistryConfig;
import java.io.IOException;

public class JsonRegistryConfigDeserializer
extends JsonDeserializer<JsonRegistryConfig> {
    public JsonRegistryConfig deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            return new JsonRegistryConfig(p.getText());
        }
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            this.ensureNextToken(p, JsonToken.FIELD_NAME, ctxt);
            String qerId = p.getCurrentName();
            this.ensureNextToken(p, JsonToken.START_OBJECT, ctxt);
            JsonRegistryConfig qer = (JsonRegistryConfig)p.readValueAs(JsonRegistryConfig.class);
            qer.setId(qerId);
            this.ensureNextToken(p, JsonToken.END_OBJECT, ctxt);
            return qer;
        }
        return null;
    }

    private void ensureNextToken(JsonParser p, JsonToken expected, DeserializationContext ctxt) throws IOException {
        if (p.nextToken() != expected) {
            throw InvalidFormatException.from((JsonParser)p, (String)("Expected " + expected), (Object)ctxt, JsonRegistryConfig.class);
        }
    }
}

