/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistration;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.internal.DefaultDialectSelector;
import org.hibernate.boot.registry.selector.internal.DefaultJtaPlatformSelector;
import org.hibernate.boot.registry.selector.internal.LazyServiceResolver;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.internal.SimpleCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.global.GlobalTemporaryTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy;
import org.hibernate.hql.spi.id.persistent.PersistentTableBulkIdStrategy;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;

public final class QuarkusStrategySelectorBuilder {
    public static StrategySelector buildSelector(ClassLoaderService classLoaderService) {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(classLoaderService);
        strategySelector.registerStrategyLazily(Dialect.class, (LazyServiceResolver)new DefaultDialectSelector());
        strategySelector.registerStrategyLazily(JtaPlatform.class, (LazyServiceResolver)new DefaultJtaPlatformSelector());
        QuarkusStrategySelectorBuilder.addTransactionCoordinatorBuilders(strategySelector);
        QuarkusStrategySelectorBuilder.addMultiTableBulkIdStrategies(strategySelector);
        QuarkusStrategySelectorBuilder.addImplicitNamingStrategies(strategySelector);
        QuarkusStrategySelectorBuilder.addCacheKeysFactories(strategySelector);
        for (StrategyRegistrationProvider provider : classLoaderService.loadJavaServices(StrategyRegistrationProvider.class)) {
            for (StrategyRegistration discoveredStrategyRegistration : provider.getStrategyRegistrations()) {
                QuarkusStrategySelectorBuilder.applyFromStrategyRegistration(strategySelector, discoveredStrategyRegistration);
            }
        }
        return strategySelector;
    }

    private static <T> void applyFromStrategyRegistration(StrategySelectorImpl strategySelector, StrategyRegistration<T> strategyRegistration) {
        for (String name : strategyRegistration.getSelectorNames()) {
            strategySelector.registerStrategyImplementor(strategyRegistration.getStrategyRole(), name, strategyRegistration.getStrategyImplementation());
        }
    }

    private static void addTransactionCoordinatorBuilders(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "jdbc", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "jta", JtaTransactionCoordinatorBuilderImpl.class);
    }

    private static void addMultiTableBulkIdStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(MultiTableBulkIdStrategy.class, "persistent", PersistentTableBulkIdStrategy.class);
        strategySelector.registerStrategyImplementor(MultiTableBulkIdStrategy.class, "global_temporary", GlobalTemporaryTableBulkIdStrategy.class);
        strategySelector.registerStrategyImplementor(MultiTableBulkIdStrategy.class, "local_temporary", LocalTemporaryTableBulkIdStrategy.class);
    }

    private static void addImplicitNamingStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "default", ImplicitNamingStrategyJpaCompliantImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "jpa", ImplicitNamingStrategyJpaCompliantImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "component-path", ImplicitNamingStrategyComponentPathImpl.class);
    }

    private static void addCacheKeysFactories(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(CacheKeysFactory.class, "default", DefaultCacheKeysFactory.class);
        strategySelector.registerStrategyImplementor(CacheKeysFactory.class, "simple", SimpleCacheKeysFactory.class);
    }
}

