/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class RuntimeLaunchClassLoader
extends ClassLoader {
    public RuntimeLaunchClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourceName = name.replace(".", "/") + ".class";
        try (InputStream is = this.getResourceAsStream(resourceName);){
            int r;
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            this.definePackage(name);
            byte[] buf = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((r = is.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            byte[] bytes = out.toByteArray();
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String name) {
        String pkgName = this.getPackageNameFromClassName(name);
        if (pkgName != null && this.getPackage(pkgName) == null) {
            Object object = this.getClassLoadingLock(pkgName);
            synchronized (object) {
                if (this.getPackage(pkgName) == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        return this.findResource(name);
    }

    @Override
    protected URL findResource(String name) {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        return this.getParent().getResource("META-INF/ide-deps" + name + ".ide-launcher-res");
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        return this.getParent().getResources("META-INF/ide-deps" + name + ".ide-launcher-res");
    }

    static {
        RuntimeLaunchClassLoader.registerAsParallelCapable();
    }
}

