/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.runtime.ObjectSubstitution;
import io.quarkus.smallrye.jwt.runtime.auth.PublicKeyProxy;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class PublicKeySubstitution
implements ObjectSubstitution<RSAPublicKey, PublicKeyProxy> {
    public PublicKeyProxy serialize(RSAPublicKey obj) {
        byte[] encoded = obj.getEncoded();
        PublicKeyProxy proxy = new PublicKeyProxy();
        proxy.setContent(encoded);
        return proxy;
    }

    public RSAPublicKey deserialize(PublicKeyProxy obj) {
        byte[] encoded = obj.getContent();
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encoded);
        RSAPublicKey rsaPubKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            rsaPubKey = (RSAPublicKey)kf.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return rsaPubKey;
    }
}

