/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.smallrye.metrics.MetricsRequestHandler;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class SmallRyeMetricsHandler
implements Handler<RoutingContext> {
    private String metricsPath;
    private static final Logger LOGGER = Logger.getLogger((String)SmallRyeMetricsHandler.class.getName());

    public void setMetricsPath(String metricsPath) {
        this.metricsPath = metricsPath;
    }

    public void handle(RoutingContext routingContext) {
        MetricsRequestHandler internalHandler = (MetricsRequestHandler)CDI.current().select(MetricsRequestHandler.class, new Annotation[0]).get();
        final HttpServerResponse response = routingContext.response();
        HttpServerRequest request = routingContext.request();
        Stream acceptHeaders = request.headers().getAll("Accept").stream();
        routingContext.currentRoute().getPath();
        routingContext.mountPoint();
        try {
            internalHandler.handleRequest(request.path(), this.metricsPath, request.method().name(), acceptHeaders, new MetricsRequestHandler.Responder(){

                public void respondWith(int status, String message, Map<String, String> headers) throws IOException {
                    response.setStatusCode(status);
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        response.putHeader(entry.getKey(), entry.getValue());
                    }
                    response.end(Buffer.buffer((String)message));
                }
            });
        }
        catch (IOException e) {
            response.setStatusCode(503);
            response.end();
            LOGGER.error((Object)e);
        }
    }
}

