/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.vertx.http.deployment.HttpSecurityProcessor;
import io.quarkus.vertx.http.deployment.ManagementInterfaceFilterBuildItem;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.ManagementInterfaceHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.ManagementPathMatchingHttpSecurityPolicy;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Singleton;

public class ManagementInterfaceSecurityProcessor {
    @BuildStep(onlyIfNot={HttpSecurityProcessor.IsApplicationBasicAuthRequired.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem initBasicAuth(ManagementInterfaceSecurityRecorder recorder, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        if (managementInterfaceBuildTimeConfig.auth.basic.orElse(false).booleanValue()) {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(BasicAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).scope(Singleton.class)).supplier(recorder.setupBasicAuth());
            return configurator.done();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(ManagementInterfaceSecurityRecorder recorder, BuildProducer<ManagementInterfaceFilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Capabilities capabilities, ManagementInterfaceBuildTimeConfig buildTimeConfig) {
        if (buildTimeConfig.auth.basic.orElse(false).booleanValue() && capabilities.isPresent("io.quarkus.security")) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(ManagementPathMatchingHttpSecurityPolicy.class).addBeanClass(ManagementInterfaceHttpAuthorizer.class).build());
            filterBuildItemBuildProducer.produce((BuildItem)new ManagementInterfaceFilterBuildItem((Handler<RoutingContext>)recorder.authenticationMechanismHandler(buildTimeConfig.auth.proactive), -200));
            filterBuildItemBuildProducer.produce((BuildItem)new ManagementInterfaceFilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(), -100));
        }
    }
}

