/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.quarkus.devui.runtime.EndpointInfo;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.List;

public class EndpointInfoHandler
implements Handler<RoutingContext> {
    private static volatile List<EndpointInfo> endpointInfos;
    private String basePath;
    private static final int STATUS = 200;
    private static final String OK = "OK";
    private static final String SLASH = "/";
    private static final String CONTENT_TYPE = "Content-Type";

    static void setEndpoints(List<EndpointInfo> endpointInfos) {
        EndpointInfoHandler.endpointInfos = endpointInfos;
    }

    public EndpointInfoHandler() {
    }

    public EndpointInfoHandler(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void handle(RoutingContext event) {
        String normalizedPath = event.normalizedPath();
        if (normalizedPath.contains(SLASH)) {
            int si = normalizedPath.lastIndexOf(SLASH) + 1;
            String path = normalizedPath.substring(0, si);
            String fileName = normalizedPath.substring(si);
            if (path.startsWith(this.basePath) && fileName.equals("endpoints.json")) {
                event.response().setStatusCode(200).setStatusMessage(OK).putHeader(CONTENT_TYPE, "application/json").end(Json.encodePrettily((Object)this.getContent()));
            } else {
                event.next();
            }
        } else {
            event.next();
        }
    }

    private JsonObject getContent() {
        HashMap<String, String> info = new HashMap<String, String>();
        for (EndpointInfo endpoint : endpointInfos) {
            info.put(endpoint.getUri(), endpoint.getDescription());
        }
        return new JsonObject(info);
    }
}

