/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.api.WebClientApplicationException;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientResponseContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.StatusTypeImpl;

public class ClientSetResponseEntityRestHandler
implements ClientRestHandler {
    public void handle(RestClientRequestContext context) throws Exception {
        Response.StatusType effectiveResponseStatus;
        ClientRequestContextImpl requestContext = context.getClientRequestContext();
        if (context.isCheckSuccessfulFamily() && Response.Status.Family.familyOf((int)(effectiveResponseStatus = this.determineEffectiveResponseStatus(context, requestContext)).getStatusCode()) != Response.Status.Family.SUCCESSFUL) {
            throw new WebClientApplicationException(effectiveResponseStatus.getStatusCode(), effectiveResponseStatus.getReasonPhrase());
        }
        if (this.isAbortedWith(requestContext)) {
            this.propagateAbortedWithEntityToResponse(context);
        }
    }

    private Response.StatusType determineEffectiveResponseStatus(RestClientRequestContext context, ClientRequestContextImpl requestContext) {
        Response abortedWith;
        StatusTypeImpl effectiveResponseStatus = new StatusTypeImpl(context.getResponseStatus(), context.getResponseReasonPhrase());
        if (effectiveResponseStatus.getStatusCode() == 0 && this.isAbortedWith(requestContext) && (abortedWith = requestContext.getAbortedWith()).getStatusInfo() != null) {
            effectiveResponseStatus = abortedWith.getStatusInfo();
        }
        return effectiveResponseStatus;
    }

    private boolean isAbortedWith(ClientRequestContextImpl requestContext) {
        return requestContext != null && requestContext.getAbortedWith() != null;
    }

    private void propagateAbortedWithEntityToResponse(RestClientRequestContext restClientRequestContext) throws IOException {
        new ClientResponseContextImpl(restClientRequestContext).setEntityStream(this.entityStreamOfAbortedResponseOf(restClientRequestContext));
    }

    private ByteArrayInputStream entityStreamOfAbortedResponseOf(RestClientRequestContext context) throws IOException {
        Entity entity;
        Response abortedWith = context.getAbortedWith();
        Object untypedEntity = abortedWith.getEntity();
        if (untypedEntity == null) {
            return null;
        }
        if (untypedEntity instanceof Entity) {
            entity = (Entity)untypedEntity;
        } else {
            MediaType mediaType = abortedWith.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.TEXT_PLAIN_TYPE;
            }
            entity = Entity.entity((Object)untypedEntity, (MediaType)mediaType);
        }
        Buffer buffer = context.writeEntity(entity, (MultivaluedMap<String, String>)Serialisers.EMPTY_MULTI_MAP, Serialisers.NO_WRITER_INTERCEPTOR);
        return new ByteArrayInputStream(buffer.getBytes());
    }
}

