/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.List;
import javax.ws.rs.NotFoundException;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.handlers.MatrixParamHandler;
import org.jboss.resteasy.reactive.server.jaxrs.ProvidersImpl;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class RestInitialHandler
implements ServerRestHandler {
    final RequestMapper<InitialMatch> mappers;
    final Deployment deployment;
    final ProvidersImpl providers;
    final List<ServerRestHandler> preMappingHandlers;
    final ServerRestHandler[] initialChain;
    final ThreadSetupAction requestContext;
    final RequestContextFactory requestContextFactory;
    final boolean resumeOn404;

    public RestInitialHandler(Deployment deployment) {
        this.mappers = new RequestMapper(deployment.getClassMappers());
        this.deployment = deployment;
        this.providers = new ProvidersImpl(deployment);
        this.preMappingHandlers = deployment.getPreMatchHandlers();
        this.resumeOn404 = deployment.isResumeOn404();
        if (this.preMappingHandlers.isEmpty()) {
            this.initialChain = new ServerRestHandler[]{new MatrixParamHandler(), this};
        } else {
            this.initialChain = new ServerRestHandler[this.preMappingHandlers.size() + 2];
            this.initialChain[0] = new MatrixParamHandler();
            for (int i = 0; i < this.preMappingHandlers.size(); ++i) {
                this.initialChain[i + 1] = this.preMappingHandlers.get(i);
            }
            this.initialChain[this.initialChain.length - 1] = this;
        }
        this.requestContext = deployment.getThreadSetupAction();
        this.requestContextFactory = deployment.getRequestContextFactory();
    }

    public void beginProcessing(Object extenalHttpContext) {
        ResteasyReactiveRequestContext rq = this.requestContextFactory.createContext(this.deployment, this.providers, extenalHttpContext, this.requestContext, this.initialChain, this.deployment.getAbortHandlerChain());
        rq.run();
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        String pathParamValue;
        RequestMapper.RequestMatch<InitialMatch> target = this.mappers.map(requestContext.getPathWithoutPrefix());
        if (target == null) {
            if (this.resumeOn404 && requestContext.resumeExternalProcessing()) {
                return;
            }
            requestContext.requireCDIRequestScope();
            requestContext.handleException((Throwable)new NotFoundException());
            return;
        }
        requestContext.restart(((InitialMatch)target.value).handlers);
        requestContext.setMaxPathParams(((InitialMatch)target.value).maxPathParams);
        requestContext.setRemaining(target.remaining);
        for (int i = 0; i < target.pathParamValues.length && (pathParamValue = target.pathParamValues[i]) != null; ++i) {
            requestContext.setPathParamValue(i, target.pathParamValues[i]);
        }
    }

    public static class InitialMatch {
        public final ServerRestHandler[] handlers;
        public final int maxPathParams;

        public InitialMatch(ServerRestHandler[] handlers, int maxPathParams) {
            this.handlers = handlers;
            this.maxPathParams = maxPathParams;
        }
    }
}

