/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.complex;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.complex.CartesianRoutingEngine;
import io.shardingsphere.core.routing.type.standard.StandardRoutingEngine;
import io.shardingsphere.core.rule.BindingTableRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public final class ComplexRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final Collection<String> logicTables;
    private final ShardingConditions shardingConditions;

    @Override
    public RoutingResult route() {
        ArrayList<RoutingResult> result = new ArrayList<RoutingResult>(this.logicTables.size());
        TreeSet bindingTableNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (String each : this.logicTables) {
            Optional<BindingTableRule> bindingTableRule;
            Optional<TableRule> tableRule = this.shardingRule.tryFindTableRuleByLogicTable(each);
            if (!tableRule.isPresent()) continue;
            if (!bindingTableNames.contains(each)) {
                result.add(new StandardRoutingEngine(this.shardingRule, ((TableRule)tableRule.get()).getLogicTable(), this.shardingConditions).route());
            }
            if (!(bindingTableRule = this.shardingRule.findBindingTableRule(each)).isPresent()) continue;
            bindingTableNames.addAll(Lists.transform(((BindingTableRule)bindingTableRule.get()).getTableRules(), (Function)new Function<TableRule, String>(){

                public String apply(TableRule input) {
                    return input.getLogicTable();
                }
            }));
        }
        if (result.isEmpty()) {
            throw new ShardingException("Cannot find table rule and default data source with logic tables: '%s'", this.logicTables);
        }
        if (1 == result.size()) {
            return (RoutingResult)result.iterator().next();
        }
        return new CartesianRoutingEngine(result).route();
    }

    @ConstructorProperties(value={"shardingRule", "logicTables", "shardingConditions"})
    public ComplexRoutingEngine(ShardingRule shardingRule, Collection<String> logicTables, ShardingConditions shardingConditions) {
        this.shardingRule = shardingRule;
        this.logicTables = logicTables;
        this.shardingConditions = shardingConditions;
    }
}

