/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.result;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.executor.sql.execute.row.QueryRow;
import io.shardingsphere.core.merger.QueryResult;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistinctQueryResult
implements QueryResult {
    private final Multimap<String, Integer> columnLabelAndIndexMap;
    private final Iterator<QueryRow> resultData;
    private QueryRow currentRow;

    public DistinctQueryResult(Collection<QueryResult> queryResults, List<String> distinctColumnLabels) {
        this.columnLabelAndIndexMap = this.getColumnLabelAndIndexMap(queryResults.iterator().next());
        this.resultData = this.getResultData(queryResults, distinctColumnLabels);
    }

    private Multimap<String, Integer> getColumnLabelAndIndexMap(QueryResult queryResult) {
        HashMultimap result = HashMultimap.create();
        for (int columnIndex = 1; columnIndex <= queryResult.getColumnCount(); ++columnIndex) {
            result.put((Object)queryResult.getColumnLabel(columnIndex), (Object)columnIndex);
        }
        return result;
    }

    private Iterator<QueryRow> getResultData(Collection<QueryResult> queryResults, List<String> distinctColumnLabels) {
        LinkedHashSet<QueryRow> result = new LinkedHashSet<QueryRow>();
        List distinctColumnIndexes = Lists.transform(distinctColumnLabels, (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return DistinctQueryResult.this.getColumnIndex(input);
            }
        });
        for (QueryResult each : queryResults) {
            this.fill(result, each, distinctColumnIndexes);
        }
        return result.iterator();
    }

    private void fill(Set<QueryRow> resultData, QueryResult queryResult, List<Integer> distinctColumnIndexes) {
        while (queryResult.next()) {
            ArrayList<Object> rowData = new ArrayList<Object>(queryResult.getColumnCount());
            for (int columnIndex = 1; columnIndex <= queryResult.getColumnCount(); ++columnIndex) {
                rowData.add(queryResult.getValue(columnIndex, Object.class));
            }
            resultData.add(new QueryRow(rowData, distinctColumnIndexes));
        }
    }

    public List<DistinctQueryResult> divide() {
        return Lists.newArrayList((Iterator)Iterators.transform(this.resultData, (Function)new Function<QueryRow, DistinctQueryResult>(){

            public DistinctQueryResult apply(QueryRow row) {
                LinkedHashSet<QueryRow> resultData = new LinkedHashSet<QueryRow>();
                resultData.add(row);
                return new DistinctQueryResult((Multimap<String, Integer>)DistinctQueryResult.this.columnLabelAndIndexMap, resultData.iterator());
            }
        }));
    }

    @Override
    public final boolean next() {
        if (this.resultData.hasNext()) {
            this.currentRow = this.resultData.next();
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) {
        return this.currentRow.getColumnValue(columnIndex);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) {
        return this.currentRow.getColumnValue(this.getColumnIndex(columnLabel));
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.currentRow.getColumnValue(columnIndex);
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        return this.currentRow.getColumnValue(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) {
        return this.getInputStream(this.currentRow.getColumnValue(columnIndex));
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) {
        return this.getInputStream(this.currentRow.getColumnValue(this.getColumnIndex(columnLabel)));
    }

    protected InputStream getInputStream(Object value) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public boolean wasNull() {
        return null == this.currentRow;
    }

    @Override
    public int getColumnCount() {
        return this.columnLabelAndIndexMap.size();
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        for (Map.Entry entry : this.columnLabelAndIndexMap.entries()) {
            if (columnIndex != (Integer)entry.getValue()) continue;
            return (String)entry.getKey();
        }
        throw new SQLException("Column index out of range", "9999");
    }

    protected Integer getColumnIndex(String columnLabel) {
        return (Integer)new ArrayList(this.columnLabelAndIndexMap.get((Object)columnLabel)).get(0);
    }

    @ConstructorProperties(value={"columnLabelAndIndexMap", "resultData"})
    public DistinctQueryResult(Multimap<String, Integer> columnLabelAndIndexMap, Iterator<QueryRow> resultData) {
        this.columnLabelAndIndexMap = columnLabelAndIndexMap;
        this.resultData = resultData;
    }

    protected Multimap<String, Integer> getColumnLabelAndIndexMap() {
        return this.columnLabelAndIndexMap;
    }

    protected Iterator<QueryRow> getResultData() {
        return this.resultData;
    }

    protected QueryRow getCurrentRow() {
        return this.currentRow;
    }
}

