/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.dql;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ExpressionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.SelectClauseSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionSegment;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public final class SelectClauseExtractor
implements OptionalSQLSegmentExtractor {
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Optional<SelectClauseSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> selectClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SELECT_CLAUSE);
        if (!selectClauseNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> selectExpressionsNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)selectClauseNode.get(), RuleName.SELECT_EXPRS);
        if (!selectExpressionsNode.isPresent()) {
            return Optional.absent();
        }
        SelectClauseSegment result = new SelectClauseSegment(((ParserRuleContext)selectExpressionsNode.get()).getStart().getStartIndex(), ((ParserRuleContext)selectExpressionsNode.get()).getStop().getStopIndex() + 2, this.hasDistinct((ParserRuleContext)selectClauseNode.get()));
        for (int i = 0; i < ((ParserRuleContext)selectExpressionsNode.get()).getChildCount(); ++i) {
            Optional<? extends ExpressionSegment> expressionSegment;
            ParseTree childNode = ((ParserRuleContext)selectExpressionsNode.get()).getChild(i);
            if (childNode instanceof TerminalNodeImpl || !(expressionSegment = this.expressionExtractor.extract((ParserRuleContext)childNode)).isPresent()) continue;
            result.getExpressions().add((ExpressionSegment)expressionSegment.get());
        }
        return Optional.of((Object)result);
    }

    private boolean hasDistinct(ParserRuleContext selectClauseNode) {
        return selectClauseNode.getChildCount() > 2 && DefaultKeyword.DISTINCT.name().equalsIgnoreCase(selectClauseNode.getChild(1).getText());
    }
}

