/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.parser.impl;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.antlr.autogen.MySQLStatementLexer;
import io.shardingsphere.core.parsing.antlr.autogen.OracleStatementLexer;
import io.shardingsphere.core.parsing.antlr.autogen.PostgreSQLStatementLexer;
import io.shardingsphere.core.parsing.antlr.autogen.SQLServerStatementLexer;
import io.shardingsphere.core.parsing.antlr.parser.impl.SQLParser;
import io.shardingsphere.core.parsing.antlr.parser.impl.dialect.MySQLParser;
import io.shardingsphere.core.parsing.antlr.parser.impl.dialect.OracleParser;
import io.shardingsphere.core.parsing.antlr.parser.impl.dialect.PostgreSQLParser;
import io.shardingsphere.core.parsing.antlr.parser.impl.dialect.SQLServerParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType databaseType, String sql) {
        return SQLParserFactory.createSQLParser(databaseType, SQLParserFactory.createLexer(databaseType, sql));
    }

    private static Lexer createLexer(DatabaseType databaseType, String sql) {
        CodePointCharStream sqlCharStream = CharStreams.fromString((String)sql);
        switch (databaseType) {
            case H2: 
            case MySQL: {
                return new MySQLStatementLexer((CharStream)sqlCharStream);
            }
            case PostgreSQL: {
                return new PostgreSQLStatementLexer((CharStream)sqlCharStream);
            }
            case SQLServer: {
                return new SQLServerStatementLexer((CharStream)sqlCharStream);
            }
            case Oracle: {
                return new OracleStatementLexer((CharStream)sqlCharStream);
            }
        }
        throw new UnsupportedOperationException(String.format("Can not support database type [%s].", new Object[]{databaseType}));
    }

    private static SQLParser createSQLParser(DatabaseType databaseType, Lexer lexer) {
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        switch (databaseType) {
            case H2: 
            case MySQL: {
                return new MySQLParser((TokenStream)tokenStream);
            }
            case PostgreSQL: {
                return new PostgreSQLParser((TokenStream)tokenStream);
            }
            case SQLServer: {
                return new SQLServerParser((TokenStream)tokenStream);
            }
            case Oracle: {
                return new OracleParser((TokenStream)tokenStream);
            }
        }
        throw new UnsupportedOperationException(String.format("Can not support database type [%s].", new Object[]{databaseType}));
    }

    private SQLParserFactory() {
    }
}

