/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.ddl.column.dialect.mysql;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ddl.column.ColumnDefinitionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ddl.column.dialect.mysql.MySQLColumnPositionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.ColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.alter.ModifyColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.position.ColumnPositionSegment;
import org.antlr.v4.runtime.ParserRuleContext;

public final class MySQLChangeColumnDefinitionExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionExtractor = new ColumnDefinitionExtractor();

    public Optional<ModifyColumnDefinitionSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> changeColumnNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.CHANGE_COLUMN);
        if (!changeColumnNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> oldColumnNameNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)changeColumnNode.get(), RuleName.COLUMN_NAME);
        if (!oldColumnNameNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> columnDefinitionNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)changeColumnNode.get(), RuleName.COLUMN_DEFINITION);
        if (!columnDefinitionNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ColumnDefinitionSegment> columnDefinitionSegment = this.columnDefinitionExtractor.extract((ParserRuleContext)columnDefinitionNode.get());
        if (columnDefinitionSegment.isPresent()) {
            ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(((ParserRuleContext)oldColumnNameNode.get()).getText(), (ColumnDefinitionSegment)columnDefinitionSegment.get());
            Optional<ColumnPositionSegment> columnPositionSegment = new MySQLColumnPositionExtractor(((ColumnDefinitionSegment)columnDefinitionSegment.get()).getColumnName()).extract((ParserRuleContext)changeColumnNode.get());
            if (columnPositionSegment.isPresent()) {
                result.setColumnPosition((ColumnPositionSegment)columnPositionSegment.get());
            }
            return Optional.of((Object)result);
        }
        return Optional.absent();
    }
}

