/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.context.condition;

import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import java.util.Collections;
import java.util.List;

public final class GeneratedKeyCondition
extends Condition {
    private final Column column;
    private final int index;
    private final Number value;

    public GeneratedKeyCondition(Column column, int index, Number value) {
        super(column, new SQLNumberExpression(value));
        this.column = column;
        this.index = index;
        this.value = value;
    }

    @Override
    public List<Comparable<?>> getConditionValues(List<?> parameters) {
        Comparable result = null == this.value ? (Comparable)parameters.get(this.index) : (Comparable)((Object)this.value);
        return Collections.singletonList(result);
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "GeneratedKeyCondition(column=" + this.getColumn() + ", index=" + this.getIndex() + ", value=" + this.getValue() + ")";
    }
}

