/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.context.orderby;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.OrderDirection;
import java.beans.ConstructorProperties;

public final class OrderItem {
    private final String owner;
    private final String name;
    private final OrderDirection orderDirection;
    private final OrderDirection nullOrderDirection;
    private int index = -1;
    private String expression;
    private String alias;

    public OrderItem(String name, OrderDirection orderDirection, OrderDirection nullOrderDirection) {
        this(null, name, orderDirection, nullOrderDirection);
    }

    public OrderItem(int index, OrderDirection orderDirection, OrderDirection nullOrderDirection) {
        this(null, null, orderDirection, nullOrderDirection);
        this.index = index;
    }

    public Optional<String> getOwner() {
        return Optional.fromNullable((Object)this.owner);
    }

    public Optional<String> getName() {
        return Optional.fromNullable((Object)this.name);
    }

    public Optional<String> getAlias() {
        return Optional.fromNullable((Object)this.alias);
    }

    public String getColumnLabel() {
        return null == this.alias ? this.name : this.alias;
    }

    public Optional<String> getQualifiedName() {
        if (null == this.name) {
            return Optional.absent();
        }
        return null == this.owner ? Optional.of((Object)this.name) : Optional.of((Object)(this.owner + "." + this.name));
    }

    public boolean isIndex() {
        return -1 != this.index;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof OrderItem)) {
            return false;
        }
        OrderItem orderItem = (OrderItem)obj;
        return this.orderDirection == orderItem.getOrderDirection() && (this.columnLabelEquals(orderItem) || this.qualifiedNameEquals(orderItem) || this.indexEquals(orderItem));
    }

    private boolean columnLabelEquals(OrderItem orderItem) {
        String columnLabel = this.getColumnLabel();
        return null != columnLabel && columnLabel.equalsIgnoreCase(orderItem.getColumnLabel());
    }

    private boolean qualifiedNameEquals(OrderItem orderItem) {
        Optional<String> thisQualifiedName = this.getQualifiedName();
        Optional<String> thatQualifiedName = orderItem.getQualifiedName();
        return thisQualifiedName.isPresent() && thatQualifiedName.isPresent() && ((String)thisQualifiedName.get()).equalsIgnoreCase((String)thatQualifiedName.get());
    }

    private boolean indexEquals(OrderItem orderItem) {
        return -1 != this.index && this.index == orderItem.getIndex();
    }

    @ConstructorProperties(value={"owner", "name", "orderDirection", "nullOrderDirection"})
    public OrderItem(String owner, String name, OrderDirection orderDirection, OrderDirection nullOrderDirection) {
        this.owner = owner;
        this.name = name;
        this.orderDirection = orderDirection;
        this.nullOrderDirection = nullOrderDirection;
    }

    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    public OrderDirection getNullOrderDirection() {
        return this.nullOrderDirection;
    }

    public int getIndex() {
        return this.index;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return "OrderItem(owner=" + this.getOwner() + ", name=" + this.getName() + ", orderDirection=" + (Object)((Object)this.getOrderDirection()) + ", nullOrderDirection=" + (Object)((Object)this.getNullOrderDirection()) + ", index=" + this.getIndex() + ", expression=" + this.getExpression() + ", alias=" + this.getAlias() + ")";
    }
}

