/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.reactive.messaging.amqp.AmqpMessageBuilder;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import io.smallrye.reactive.messaging.amqp.ce.AmqpCloudEventHelper;
import io.smallrye.reactive.messaging.amqp.fault.AmqpFailureHandler;
import io.smallrye.reactive.messaging.ce.IncomingCloudEventMetadata;
import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.vertx.core.Context;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.MessageError;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class AmqpMessage<T>
implements ContextAwareMessage<T>,
MetadataInjectableMessage<T> {
    protected static final String APPLICATION_JSON = "application/json";
    protected final io.vertx.amqp.AmqpMessage message;
    protected Metadata metadata;
    protected final IncomingAmqpMetadata amqpMetadata;
    private final io.vertx.mutiny.core.Context context;
    protected final AmqpFailureHandler onNack;
    private final T payload;

    @Deprecated
    public static <T> AmqpMessageBuilder<T> builder() {
        return new AmqpMessageBuilder();
    }

    public AmqpMessage(io.vertx.mutiny.amqp.AmqpMessage delegate, io.vertx.mutiny.core.Context context, AmqpFailureHandler onNack, boolean cloudEventEnabled, Boolean tracingEnabled) {
        this(delegate.getDelegate(), context, onNack, cloudEventEnabled, tracingEnabled);
    }

    public AmqpMessage(io.vertx.mutiny.amqp.AmqpMessage delegate, io.vertx.mutiny.core.Context context, OutgoingAmqpMetadata amqpMetadata) {
        this.message = delegate.getDelegate();
        this.context = context;
        this.amqpMetadata = null;
        this.onNack = null;
        this.payload = this.convert(this.message);
        this.metadata = Metadata.of((Object[])new Object[]{amqpMetadata});
    }

    public AmqpMessage(io.vertx.amqp.AmqpMessage msg, io.vertx.mutiny.core.Context context, AmqpFailureHandler onNack, boolean cloudEventEnabled, Boolean tracingEnabled) {
        this.message = msg;
        this.context = context;
        this.amqpMetadata = new IncomingAmqpMetadata(this.message);
        this.onNack = onNack;
        ArrayList<IncomingAmqpMetadata> meta = new ArrayList<IncomingAmqpMetadata>();
        meta.add(this.amqpMetadata);
        if (cloudEventEnabled) {
            AmqpCloudEventHelper.CloudEventMode mode = AmqpCloudEventHelper.getCloudEventMode(msg);
            switch (mode) {
                case NOT_A_CLOUD_EVENT: {
                    this.payload = this.convert(this.message);
                    break;
                }
                case STRUCTURED: {
                    IncomingCloudEventMetadata event = AmqpCloudEventHelper.createFromStructuredCloudEvent(msg);
                    meta.add((IncomingAmqpMetadata)event);
                    this.payload = event.getData();
                    break;
                }
                case BINARY: {
                    this.payload = this.convert(this.message);
                    meta.add((IncomingAmqpMetadata)AmqpCloudEventHelper.createFromBinaryCloudEvent(msg, this));
                    break;
                }
                default: {
                    this.payload = this.convert(this.message);
                    break;
                }
            }
        } else {
            this.payload = this.convert(this.message);
        }
        this.metadata = ContextAwareMessage.captureContextMetadata(meta);
    }

    public CompletionStage<Void> ack() {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            this.message.accepted();
            this.runOnMessageContext(() -> f.complete(null));
        });
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.onNack.handle(this, this.context, reason);
    }

    public T getPayload() {
        return this.payload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private Object convert(io.vertx.amqp.AmqpMessage msg) {
        Section body = msg.unwrap().getBody();
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value instanceof Binary) {
                Binary bin = (Binary)value;
                byte[] bytes = new byte[bin.getLength()];
                System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
                return bytes;
            }
            return value;
        }
        if (body instanceof AmqpSequence) {
            return ((AmqpSequence)body).getValue();
        }
        if (body instanceof Data) {
            Binary bin = ((Data)body).getValue();
            byte[] bytes = new byte[bin.getLength()];
            System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            if (APPLICATION_JSON.equalsIgnoreCase(msg.contentType())) {
                return Buffer.buffer((byte[])bytes).toJson();
            }
            return bytes;
        }
        return body;
    }

    public Message unwrap() {
        return this.message.unwrap();
    }

    public boolean isDurable() {
        return this.amqpMetadata.isDurable();
    }

    public long getDeliveryCount() {
        return this.amqpMetadata.getDeliveryCount();
    }

    public int getPriority() {
        return this.amqpMetadata.getPriority();
    }

    public long getTtl() {
        return this.amqpMetadata.getTtl();
    }

    public Object getMessageId() {
        return this.amqpMetadata.getId();
    }

    public long getGroupSequence() {
        return this.amqpMetadata.getGroupSequence();
    }

    public long getCreationTime() {
        return this.amqpMetadata.getCreationTime();
    }

    public String getAddress() {
        return this.amqpMetadata.getAddress();
    }

    public String getGroupId() {
        return this.amqpMetadata.getGroupId();
    }

    public String getContentType() {
        return this.amqpMetadata.getContentType();
    }

    public long getExpiryTime() {
        return this.amqpMetadata.getExpiryTime();
    }

    public Object getCorrelationId() {
        return this.amqpMetadata.getCorrelationId();
    }

    public String getContentEncoding() {
        return this.amqpMetadata.getContentEncoding();
    }

    public String getSubject() {
        return this.amqpMetadata.getSubject();
    }

    public JsonObject getApplicationProperties() {
        return this.amqpMetadata.getProperties();
    }

    public Section getBody() {
        return this.message.unwrap().getBody();
    }

    public MessageError getError() {
        return this.message.unwrap().getError();
    }

    public io.vertx.mutiny.amqp.AmqpMessage getAmqpMessage() {
        return new io.vertx.mutiny.amqp.AmqpMessage(this.message);
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((AmqpMessage)this).nack(arg_0);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }
}

