/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.memory;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class InMemoryConnectorCommonConfiguration {
    protected final Config config;

    public InMemoryConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public void validate() {
    }
}

